/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.container.grizzly;

import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.server.impl.ThreadLocalInvoker;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ReloadListener;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;

public final class GrizzlyContainer
extends GrizzlyAdapter
implements ContainerListener {
    private WebApplication application;
    private String basePath = "/";
    private final ThreadLocalInvoker<GrizzlyRequest> requestInvoker = new ThreadLocalInvoker();
    private final ThreadLocalInvoker<GrizzlyResponse> responseInvoker = new ThreadLocalInvoker();

    public GrizzlyContainer(ResourceConfig rc, WebApplication app) throws ContainerException {
        this.application = app;
        GenericEntity<ThreadLocal<GrizzlyRequest>> requestThreadLocal = new GenericEntity<ThreadLocal<GrizzlyRequest>>(this.requestInvoker.getImmutableThreadLocal()){};
        rc.getSingletons().add(new ContextInjectableProvider(requestThreadLocal.getType(), requestThreadLocal.getEntity()));
        GenericEntity<ThreadLocal<GrizzlyResponse>> responseThreadLocal = new GenericEntity<ThreadLocal<GrizzlyResponse>>(this.responseInvoker.getImmutableThreadLocal()){};
        rc.getSingletons().add(new ContextInjectableProvider(responseThreadLocal.getType(), responseThreadLocal.getEntity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            this.requestInvoker.set(request);
            this.responseInvoker.set(response);
            this._service(request, response);
        }
        finally {
            this.requestInvoker.set(null);
            this.responseInvoker.set(null);
        }
    }

    private void _service(GrizzlyRequest request, GrizzlyResponse response) {
        WebApplication _application = this.application;
        URI baseUri = this.getBaseUri(request);
        URI requestUri = baseUri.resolve(request.getRequest().unparsedURI().toString());
        if (!requestUri.getRawPath().startsWith(this.basePath)) {
            response.setStatus(404);
            return;
        }
        try {
            ContainerRequest cRequest = new ContainerRequest(_application, request.getMethod(), baseUri, requestUri, this.getHeaders(request), (InputStream)request.getInputStream());
            _application.handleRequest(cRequest, new Writer(response));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
    }

    public void setResourcesContextPath(String resourcesContextPath) {
        super.setResourcesContextPath(resourcesContextPath);
        this.basePath = resourcesContextPath == null || resourcesContextPath.length() == 0 ? "/" : (resourcesContextPath.charAt(resourcesContextPath.length() - 1) != '/' ? resourcesContextPath + "/" : resourcesContextPath);
        if (this.basePath.charAt(0) != '/') {
            throw new IllegalArgumentException("The resource context path, " + resourcesContextPath + ", must start with a '/'");
        }
    }

    private URI getBaseUri(GrizzlyRequest request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.basePath, null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private InBoundHeaders getHeaders(GrizzlyRequest request) {
        InBoundHeaders rh = new InBoundHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            rh.add(name, value);
        }
        return rh;
    }

    @Override
    public void onReload() {
        WebApplication oldApplication = this.application;
        this.application = this.application.clone();
        if (this.application.getFeaturesAndProperties() instanceof ReloadListener) {
            ((ReloadListener)((Object)this.application.getFeaturesAndProperties())).onReload();
        }
        oldApplication.destroy();
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final GrizzlyResponse response;

        Writer(GrizzlyResponse response) {
            this.response = response;
        }

        @Override
        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            this.response.setStatus(cResponse.getStatus());
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : cResponse.getHttpHeaders().entrySet()) {
                for (Object value : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), ContainerResponse.getHeaderValue(value));
                }
            }
            String contentType = this.response.getHeader("Content-Type");
            if (contentType != null) {
                this.response.setContentType(contentType);
            }
            return this.response.getOutputStream();
        }

        @Override
        public void finish() throws IOException {
        }
    }

    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        protected ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }
}

