/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class StreamingStateTransferTest
extends ChannelTestBase {
    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testTransfer() {
        String[] channelNames = new String[]{"A", "B", "C", "D"};
        this.transferHelper(channelNames, false);
    }

    public void testRpcChannelTransfer() {
        String[] channelNames = new String[]{"A", "B", "C", "D"};
        this.transferHelper(channelNames, true);
    }

    public void transferHelper(String[] channelNames, boolean useDispatcher) {
        this.transferHelper(channelNames, false, false, useDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transferHelper(String[] channelNames, boolean crash, boolean largeTransfer, boolean useDispatcher) {
        int channelCount = channelNames.length;
        ArrayList<StreamingStateTransferApplication> channels = new ArrayList<StreamingStateTransferApplication>(channelCount);
        Semaphore semaphore = new Semaphore(channelCount);
        try {
            try {
                semaphore.acquire(channelCount);
                boolean crashed = false;
                for (int i = 0; i < channelCount; ++i) {
                    StreamingStateTransferApplication channel = null;
                    channel = new StreamingStateTransferApplication(channelNames[i], semaphore, useDispatcher, largeTransfer);
                    channels.add(channel);
                    semaphore.release(1);
                    channel.start();
                    Util.sleep(2000L);
                    if (!crash || crashed || i <= 2) continue;
                    StreamingStateTransferApplication coord = (StreamingStateTransferApplication)channels.remove(0);
                    coord.cleanup();
                    crashed = true;
                }
                StreamingStateTransferTest.blockUntilViewsReceived(channels, 60000L);
                boolean acquired = semaphore.tryAcquire(channelCount, 60L, TimeUnit.SECONDS);
                if (!acquired) {
                    this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                    this.log.warn((Object)Util.dumpThreads());
                }
                int getStateInvokedCount = 0;
                int setStateInvokedCount = 0;
                int partialGetStateInvokedCount = 0;
                int partialSetStateInvokedCount = 0;
                Util.sleep(3000L);
                for (int i = 0; i < channels.size(); ++i) {
                    StreamingStateTransferApplication current = (StreamingStateTransferApplication)channels.get(i);
                    if (current.getStateInvoked) {
                        ++getStateInvokedCount;
                    }
                    if (current.setStateInvoked) {
                        ++setStateInvokedCount;
                    }
                    if (current.partialGetStateInvoked) {
                        ++partialGetStateInvokedCount;
                    }
                    if (current.partialSetStateInvoked) {
                        ++partialSetStateInvokedCount;
                    }
                    Map map = current.getMap();
                    for (int j = 0; j < channels.size(); ++j) {
                        StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(j);
                        List l = (List)map.get(app.getLocalAddress());
                        int size = l != null ? l.size() : 0;
                        StreamingStateTransferTest.assertEquals((String)"Correct element count in map ", (int)25, (int)size);
                    }
                }
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of getState ", (int)1, (int)getStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of setState ", (int)(channelCount - 1), (int)setStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial getState ", (int)1, (int)partialGetStateInvokedCount);
                StreamingStateTransferTest.assertEquals((String)"Correct invocation count of partial setState ", (int)(channelCount - 1), (int)partialSetStateInvokedCount);
            }
            catch (Exception ex) {
                this.log.warn((Object)ex);
                Object var22_25 = null;
                for (int i = 0; i < channels.size(); ++i) {
                    StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(i);
                    Util.sleep(500L);
                    app.cleanup();
                }
                return;
            }
            Object var22_24 = null;
        }
        catch (Throwable throwable) {
            Object var22_26 = null;
            int i = 0;
            while (true) {
                if (i >= channels.size()) {
                    throw throwable;
                }
                StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(i);
                Util.sleep(500L);
                app.cleanup();
                ++i;
            }
        }
        for (int i = 0; i < channels.size(); ++i) {
            StreamingStateTransferApplication app = (StreamingStateTransferApplication)channels.get(i);
            Util.sleep(500L);
            app.cleanup();
        }
    }

    public static Test suite() {
        return new TestSuite(StreamingStateTransferTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{StreamingStateTransferTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class StreamingStateTransferApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final Map stateMap;
        public static final int COUNT = 25;
        boolean partialSetStateInvoked;
        boolean partialGetStateInvoked;
        boolean setStateInvoked;
        boolean getStateInvoked;
        boolean largeTransfer;

        public StreamingStateTransferApplication(String name, Semaphore s, boolean useDispatcher, boolean largeTransfer) throws Exception {
            super(name, s, useDispatcher);
            this.stateMap = new HashMap();
            this.partialSetStateInvoked = false;
            this.partialGetStateInvoked = false;
            this.setStateInvoked = false;
            this.getStateInvoked = false;
            this.largeTransfer = false;
            this.largeTransfer = largeTransfer;
            this.channel.connect("test");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            Address sender = msg.getSrc();
            Map map = this.stateMap;
            synchronized (map) {
                ArrayList<Object> list = (ArrayList<Object>)this.stateMap.get(sender);
                if (list == null) {
                    list = new ArrayList<Object>();
                    this.stateMap.put(sender, list);
                }
                list.add(msg.getObject());
            }
        }

        public Map getMap() {
            return this.stateMap;
        }

        public void useChannel() throws Exception {
            for (int i = 0; i < 25; ++i) {
                this.channel.send(null, null, new Integer(i));
            }
            this.channel.getState(null, 25000L);
            this.channel.getState(null, this.name, 25000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void getState(OutputStream ostream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                try {
                    oos = new ObjectOutputStream(ostream);
                    HashMap copy = null;
                    Map map = this.stateMap;
                    synchronized (map) {
                        copy = new HashMap(this.stateMap);
                    }
                    oos.writeObject(copy);
                    oos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var7_7 = null;
                    this.getStateInvoked = true;
                    Util.close(oos);
                    return;
                }
                Object var7_6 = null;
                this.getStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.getStateInvoked = true;
                Util.close(oos);
                throw throwable;
            }
            Util.close(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            byte[] result = null;
            try {
                try {
                    Map map = this.stateMap;
                    synchronized (map) {
                        result = Util.objectToByteBuffer(this.stateMap);
                    }
                    Object var5_5 = null;
                    this.getStateInvoked = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var5_6 = null;
                    this.getStateInvoked = true;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.getStateInvoked = true;
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            Map result = null;
            try {
                try {
                    result = (Map)Util.objectFromByteBuffer(state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    this.setStateInvoked = true;
                }
                Object var5_3 = null;
                this.setStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setStateInvoked = true;
                throw throwable;
            }
            Map map = this.stateMap;
            synchronized (map) {
                this.stateMap.clear();
                this.stateMap.putAll(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setState(InputStream istream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                try {
                    ois = new ObjectInputStream(istream);
                    Map map = (Map)ois.readObject();
                    Map map2 = this.stateMap;
                    synchronized (map2) {
                        this.stateMap.clear();
                        this.stateMap.putAll(map);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var7_7 = null;
                    this.setStateInvoked = true;
                    Util.close(ois);
                    return;
                }
                Object var7_6 = null;
                this.setStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.setStateInvoked = true;
                Util.close(ois);
                throw throwable;
            }
            Util.close(ois);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String stateId, byte[] state) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            Object nameTransfer = null;
            try {
                try {
                    nameTransfer = Util.objectFromByteBuffer(state);
                    TestCase.assertEquals((String)"Got partial state requested ", (Object)nameTransfer, (Object)this.name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var6_5 = null;
                    this.partialSetStateInvoked = true;
                }
                Object var6_4 = null;
                this.partialSetStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.partialSetStateInvoked = true;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState(String stateId) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            byte[] result = null;
            try {
                try {
                    result = Util.objectToByteBuffer(stateId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    this.partialGetStateInvoked = true;
                }
                Object var5_3 = null;
                this.partialGetStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.partialGetStateInvoked = true;
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setState(String state_id, InputStream istream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.setState(state_id, istream);
            ObjectInputStream ois = null;
            try {
                try {
                    ois = new ObjectInputStream(istream);
                    TestCase.assertEquals((String)"Got partial state requested ", (Object)ois.readObject(), (Object)this.name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var6_5 = null;
                    this.partialSetStateInvoked = true;
                    Util.close(ois);
                    return;
                }
                Object var6_4 = null;
                this.partialSetStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.partialSetStateInvoked = true;
                Util.close(ois);
                throw throwable;
            }
            Util.close(ois);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void getState(String state_id, OutputStream ostream) {
            if (this.largeTransfer) {
                Util.sleep(4000L);
            }
            super.getState(state_id, ostream);
            ObjectOutputStream oos = null;
            try {
                try {
                    oos = new ObjectOutputStream(ostream);
                    oos.writeObject(state_id);
                    oos.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var6_5 = null;
                    this.partialGetStateInvoked = true;
                    Util.close(oos);
                    return;
                }
                Object var6_4 = null;
                this.partialGetStateInvoked = true;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.partialGetStateInvoked = true;
                Util.close(oos);
                throw throwable;
            }
            Util.close(oos);
        }
    }
}

