/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class DynamicFilterParameterSpecification
implements ParameterSpecification {
    private final String filterName;
    private final String parameterName;
    private final Type definedParameterType;

    public DynamicFilterParameterSpecification(String filterName, String parameterName, Type definedParameterType) {
        this.filterName = filterName;
        this.parameterName = parameterName;
        this.definedParameterType = definedParameterType;
    }

    public int bind(PreparedStatement statement, QueryParameters qp, SessionImplementor session, int start) throws SQLException {
        Object value;
        int columnSpan = this.definedParameterType.getColumnSpan(session.getFactory());
        if (Collection.class.isInstance(value = session.getFilterParameterValue(this.filterName + '.' + this.parameterName))) {
            int positions = 0;
            Iterator itr = ((Collection)value).iterator();
            while (itr.hasNext()) {
                this.definedParameterType.nullSafeSet(statement, itr.next(), start + positions, session);
                positions += columnSpan;
            }
            return positions;
        }
        this.definedParameterType.nullSafeSet(statement, value, start, session);
        return columnSpan;
    }

    public Type getExpectedType() {
        return this.definedParameterType;
    }

    public void setExpectedType(Type expectedType) {
    }

    public String renderDisplayInfo() {
        return "dynamic-filter={filterName=" + this.filterName + ",paramName=" + this.parameterName + "}";
    }
}

