/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.naming.api.FieldCoder;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameCoder;
import org.objectweb.jorm.naming.api.PNameGetter;
import org.objectweb.jorm.naming.lib.MapPNameGetter;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;

public class StateGenerator
extends CommonGenerator {
    private static final String OBJECT_T = StateGenerator.getJVMType(Object.class);
    private static final String STRING_T = StateGenerator.getJVMType(String.class);
    private static final String PNAME_T = StateGenerator.getJVMType(PName.class);
    private static final String PNAME_CODER_T = StateGenerator.getJVMType(PNameCoder.class);
    private static final String PNAME_GETTER_T = StateGenerator.getJVMType(PNameGetter.class);
    private static final String PNAME_CODER_N = StateGenerator.getJVMClassName(PNameCoder.class);
    private static final String PNAME_GETTER_N = StateGenerator.getJVMClassName(PNameGetter.class);
    private static final String MAP_GETTER_N = StateGenerator.getJVMClassName(MapPNameGetter.class);
    private static final String FIELD_CODER = StateGenerator.getJVMClassName(FieldCoder.class);
    private static final String ENCODE = "encode";
    private static final String ENCODE_PARAMS = "(" + STRING_T + PNAME_T + ")" + PNAME_GETTER_T;
    private static final String DECODE = "decode";
    private static final String DECODE_PARAMS = "(" + STRING_T + PNAME_GETTER_T + OBJECT_T + ")" + PNAME_T;
    private Class clazz;
    private TargetHolder holder;
    private JormCompilerParameter params;
    private RdbClassMapping rcm;
    private Collection pncolumns;
    private String name;
    private String sup;
    private String acc;
    private ClassWriter cw;
    private Map types = new HashMap();
    private Map emitted = new HashMap();
    private static final String[] ACCESSOR_EX = new String[]{StateGenerator.getJVMClassName(PException.class)};

    public StateGenerator() {
    }

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter pc) throws PException {
        StateGenerator gen = new StateGenerator(clazz, holder, pc);
        gen.emit();
    }

    private StateGenerator(Class clazz, TargetHolder holder, JormCompilerParameter params) {
        this.clazz = clazz;
        this.holder = holder;
        this.params = params;
        this.rcm = this.getRdbClassMapping();
        this.pncolumns = this.getPNameColumns(clazz);
        this.name = StateGenerator.getJVMClassName(clazz.getFQName() + "State");
        if (params.getStateInheritance() != null) {
            this.sup = StateGenerator.getJVMClassName(params.getStateInheritance());
        }
        this.acc = StateGenerator.getJVMClassName(clazz.getFQName() + "Accessor");
        this.cw = new ClassWriter(true);
        this.cw.visit(196653, 1057, this.name, this.sup, new String[]{this.acc, FIELD_CODER}, this.name);
        CodeVisitor cd = this.cw.visitMethod(1, "<init>", "()V", null, null);
        if (this.sup != null) {
            cd.visitVarInsn(25, 0);
            cd.visitMethodInsn(183, this.sup, "<init>", "()V");
        }
        cd.visitInsn(177);
        cd.visitMaxs(0, 0);
    }

    private RdbClassMapping getRdbClassMapping() {
        ClassProject cp = this.clazz.getClassProject(this.params.getProjectName());
        Mapping rdb = cp.getMapping("rdb");
        return (RdbClassMapping)rdb.getClassMapping();
    }

    private NameDef name(Collection ndefs) {
        if (ndefs.isEmpty()) {
            return null;
        }
        if (ndefs.size() > 1) {
            throw new IllegalArgumentException("too many names: " + ndefs);
        }
        return (NameDef)ndefs.iterator().next();
    }

    private Collection getPNameColumns(Class clazz) {
        NameDef nd = this.name(clazz.getNameDefs());
        if (nd != null) {
            return this.getColumns(nd);
        }
        Collection sups = clazz.getSuperClasses();
        Iterator it = sups.iterator();
        while (it.hasNext()) {
            Class sup = (Class)it.next();
            Collection result = this.getPNameColumns(sup);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Collection getColumns(NameDef nd) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = nd.iterateField();
        while (it.hasNext()) {
            String field = (String)it.next();
            result.add(this.getColumn(field));
        }
        return result;
    }

    private String field(String field, TypedElement el) throws PExceptionCompiler {
        return this.field(field, el.getType());
    }

    private String field(String field, PType type) throws PExceptionCompiler {
        return this.field(field, StateGenerator.getJVMType(type));
    }

    private String field(String field, java.lang.Class type) throws PExceptionCompiler {
        return this.field(field, StateGenerator.getJVMType(type));
    }

    private String field(String field, String type) throws PExceptionCompiler {
        String result = (String)this.types.get(field);
        if (result == null) {
            this.cw.visitField(2, field, type, null, null);
            this.types.put(field, type);
            result = type;
        } else if (!type.equals(result)) {
            throw new PExceptionCompiler("incompatible types for field '" + field + "': " + type + ", " + result);
        }
        return result;
    }

    private int getOpcode(String type, int code) {
        return Type.getType(type).getOpcode(code);
    }

    private void accessors(TypedElement el, String field, boolean ref) {
        String fn = this.upperFL(el.getName());
        String type = (String)this.types.get(field);
        CodeVisitor cd = this.cw.visitMethod(1, "paSet" + fn, "(" + type + (ref ? OBJECT_T : "") + ")V", (String[])(ref ? ACCESSOR_EX : null), null);
        cd.visitVarInsn(25, 0);
        cd.visitVarInsn(this.getOpcode(type, 21), 1);
        cd.visitFieldInsn(181, this.name, field, type);
        cd.visitInsn(177);
        cd.visitMaxs(0, 0);
        cd = this.cw.visitMethod(1, "paGet" + fn, "(" + (ref ? OBJECT_T : "") + ")" + type, (String[])(ref ? ACCESSOR_EX : null), null);
        cd.visitVarInsn(25, 0);
        cd.visitFieldInsn(180, this.name, field, type);
        cd.visitInsn(this.getOpcode(type, 172));
        cd.visitMaxs(0, 0);
        this.emitted.put(el, field);
    }

    private boolean isMappedOnPName(Reference ref) {
        return this.pncolumns.containsAll(this.getColumns(this.name(ref.getRefNameDef())));
    }

    private void emit() throws PException {
        TypedElement el;
        List mappings = this.rcm.getAllPrimitiveElementMappings();
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)it.next();
            el = (TypedElement)pem.getLinkedMO();
            String col = pem.getName();
            this.field(col, el.getType());
            this.accessors(el, col, false);
        }
        Collection fields = this.clazz.getAllFields();
        Iterator it2 = fields.iterator();
        while (it2.hasNext()) {
            el = (TypedElement)it2.next();
            if (this.emitted.containsKey(el)) continue;
            if (el instanceof Reference) {
                Reference ref = (Reference)el;
                if (this.isMappedOnPName(ref)) {
                    String fn = ref.getName() + "PName";
                    this.field(fn, class$org$objectweb$jorm$naming$api$PName == null ? StateGenerator.class$("org.objectweb.jorm.naming.api.PName") : class$org$objectweb$jorm$naming$api$PName);
                    this.accessors((TypedElement)ref, fn, true);
                    continue;
                }
                this.reference(ref);
                continue;
            }
            this.field(el.getName(), el.getType());
            this.accessors(el, el.getName(), false);
        }
        StateGenerator.write(this.cw, this.name, this.holder);
    }

    private void readColumn(CodeVisitor cv, int obj, String field, String col) {
        cv.visitVarInsn(25, obj);
        if (field == null) {
            cv.visitInsn(1);
        } else {
            cv.visitLdcInsn(field);
        }
        cv.visitVarInsn(25, 0);
        String ft = (String)this.types.get(col);
        cv.visitFieldInsn(180, this.name, col, ft);
        String param = Type.getType(ft).getSort() == 10 ? OBJECT_T : ft;
        cv.visitMethodInsn(182, MAP_GETTER_N, "set", "(" + STRING_T + param + ")V");
    }

    private void writeColumn(CodeVisitor cv, String col, int obj, String getter, String field, int ctx) {
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, obj);
        if (field == null) {
            cv.visitInsn(1);
        } else {
            cv.visitLdcInsn(field);
        }
        cv.visitVarInsn(25, ctx);
        String ft = (String)this.types.get(col);
        cv.visitMethodInsn(185, PNAME_GETTER_N, getter, "(" + STRING_T + OBJECT_T + ")" + ft);
        cv.visitFieldInsn(181, this.name, col, ft);
    }

    private TypedElement getField(String field) {
        TypedElement result = this.clazz.getTypedElement(field);
        if (result == null) {
            throw new IllegalArgumentException("class " + this.clazz.getFQName() + " has no such field: " + field);
        }
        return result;
    }

    private String getColumn(String field) {
        RdbPrimitiveElementMapping pem = (RdbPrimitiveElementMapping)this.rcm.getPrimitiveElementMapping(field, true);
        return pem.getName();
    }

    private void reference(Reference ref) throws PException {
        String pn = this.upperFL(ref.getName());
        CodeVisitor getter = this.cw.visitMethod(1, "paGet" + pn, "(" + OBJECT_T + ")" + PNAME_T, ACCESSOR_EX, null);
        CodeVisitor setter = this.cw.visitMethod(1, "paSet" + pn, "(" + PNAME_T + OBJECT_T + ")V", ACCESSOR_EX, null);
        Label end = new Label();
        NameDef ndef = this.name(ref.getRefNameDef());
        if (ndef.isNameRef()) {
            Label nonNull = new Label();
            Iterator it = ndef.iterateField();
            while (it.hasNext()) {
                String field = (String)it.next();
                String col = this.getColumn(field);
                if (this.pncolumns.contains(col)) continue;
                PType type = this.getField(field).getType();
                String jvmType = this.field(col, type);
                getter.visitVarInsn(25, 0);
                getter.visitFieldInsn(180, this.name, col, jvmType);
                StateGenerator.any2I(getter, jvmType);
                StateGenerator.loadNull(getter, type);
                StateGenerator.any2I(getter, jvmType);
                if (Type.getType(jvmType).getSort() == 10) {
                    getter.visitJumpInsn(166, nonNull);
                    continue;
                }
                getter.visitJumpInsn(160, nonNull);
            }
            getter.visitInsn(1);
            getter.visitVarInsn(58, 2);
            getter.visitJumpInsn(167, end);
            getter.visitLabel(nonNull);
        }
        getter.visitTypeInsn(187, MAP_GETTER_N);
        getter.visitInsn(89);
        getter.visitMethodInsn(183, MAP_GETTER_N, "<init>", "()V");
        getter.visitVarInsn(58, 2);
        setter.visitVarInsn(25, 0);
        setter.visitLdcInsn(ref.getName());
        setter.visitVarInsn(25, 1);
        setter.visitMethodInsn(182, this.name, ENCODE, ENCODE_PARAMS);
        setter.visitVarInsn(58, 3);
        if (ndef.isFieldName()) {
            String field = ndef.getFieldName();
            String col = this.getColumn(field);
            this.readColumn(getter, 2, null, col);
            this.writeColumn(setter, col, 3, this.getPNameGetterGetFunction(this.getField(field).getType()), null, 2);
        } else if (ndef.isNameRef()) {
            NameRef nref = ndef.getNameRef();
            CompositeName cn = nref.getCompositeName();
            Collection fields = cn.getAllFields();
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                PrimitiveElement pe = (PrimitiveElement)it.next();
                String cnfield = pe.getName();
                String nrfield = nref.getClassFieldName(cnfield);
                String col = this.getColumn(nrfield);
                this.readColumn(getter, 2, cnfield, col);
                this.writeColumn(setter, col, 3, this.getPNameGetterGetFunction(pe.getType()), cnfield, 2);
            }
        } else {
            throw new IllegalStateException("unknown kind of name definition: " + ndef);
        }
        getter.visitLabel(end);
        getter.visitVarInsn(25, 0);
        getter.visitLdcInsn(ref.getName());
        getter.visitVarInsn(25, 2);
        getter.visitVarInsn(25, 1);
        getter.visitMethodInsn(182, this.name, DECODE, DECODE_PARAMS);
        getter.visitInsn(176);
        getter.visitMaxs(0, 0);
        setter.visitInsn(177);
        setter.visitMaxs(0, 0);
    }
}

