/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.security.auth.JGroup;
import org.ow2.jonas.lib.security.auth.JPrincipal;
import org.ow2.jonas.lib.security.auth.JRole;
import org.ow2.jonas.security.auth.callback.CertificateCallback;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;

public class JDirectResourceLoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map options = null;
    private String principalName = null;
    private String password = null;
    private ArrayList principalRoles = null;
    private boolean loginWasDoneWithSuccess = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No handler has been defined.");
        }
        String resourceName = (String)this.options.get("resourceName");
        String certCallback = (String)this.options.get("certCallback");
        if (resourceName == null) {
            throw new LoginException("You have to give an argument to this login module. The 'resourceName' parameter is required.");
        }
        try {
            InitialContext ictx = new InitialContext();
            JResource jResource = null;
            try {
                jResource = (JResource)ictx.lookup(resourceName);
            }
            catch (Exception e) {
                throw JDirectResourceLoginModule.createChainedLoginException("Cannot retrieve the resource '" + resourceName + "'. Check that this resource is bound in the registry", e);
            }
            NameCallback nameCallback = new NameCallback("User :");
            PasswordCallback passwordCallback = new PasswordCallback("Password :", false);
            CertificateCallback certificateCallback = new CertificateCallback();
            Callback[] callbacks = null;
            callbacks = certCallback != null && Boolean.valueOf(certCallback) != false ? new Callback[]{nameCallback, passwordCallback, certificateCallback} : new Callback[]{nameCallback, passwordCallback};
            this.callbackHandler.handle(callbacks);
            this.principalName = nameCallback.getName();
            if (this.principalName == null) {
                throw new LoginException("A null username is not a valid username");
            }
            if (this.principalName.startsWith("##DN##") && certificateCallback.getUserCertificate() == null) {
                throw new LoginException("Name must have a certificate to access this certificate based access login");
            }
            char[] arrayPass = passwordCallback.getPassword();
            if (arrayPass == null) {
                throw new LoginException("A null password is not a valid password");
            }
            JUser user = null;
            try {
                user = jResource.findUser(this.principalName);
            }
            catch (Exception jre) {
                throw JDirectResourceLoginModule.createChainedLoginException("Can not find the user", jre);
            }
            if (user == null) {
                throw new LoginException("User '" + this.principalName + "' not found.");
            }
            boolean validated = jResource.isValidUser(user, new String(arrayPass));
            if (!validated) {
                throw new LoginException("The password for the user '" + this.principalName + "' is not valid");
            }
            this.password = user.getPassword() != null ? user.getPassword() : new String(arrayPass);
            try {
                this.principalRoles = jResource.getArrayListCombinedRoles(user);
            }
            catch (JResourceException jre) {
                throw JDirectResourceLoginModule.createChainedLoginException(jre.getMessage(), (Exception)((Object)jre));
            }
        }
        catch (Exception e) {
            throw JDirectResourceLoginModule.createChainedLoginException("Error during the login phase : " + e.getMessage(), e);
        }
        this.loginWasDoneWithSuccess = true;
        return true;
    }

    private static LoginException createChainedLoginException(String msg, Exception e) {
        LoginException le = new LoginException(msg);
        le.initCause(e);
        return le;
    }

    public boolean commit() throws LoginException {
        if (this.loginWasDoneWithSuccess) {
            this.subject.getPrincipals().add((Principal)new JPrincipal(this.principalName));
            this.subject.getPrivateCredentials().add(this.password);
            JGroup group = new JGroup("Roles");
            String[] roles = new String[this.principalRoles.size()];
            roles = this.principalRoles.toArray(roles);
            int size = this.principalRoles.size();
            for (int i = 0; i < size; ++i) {
                group.addMember((Principal)new JRole(roles[i]));
            }
            this.subject.getPrincipals().add((Principal)group);
        }
        return this.loginWasDoneWithSuccess;
    }

    public boolean abort() throws LoginException {
        if (this.loginWasDoneWithSuccess) {
            this.principalName = null;
            this.principalRoles = null;
        }
        return this.loginWasDoneWithSuccess;
    }

    public boolean logout() throws LoginException {
        if (this.loginWasDoneWithSuccess) {
            this.subject.getPrincipals().remove(new JPrincipal(this.principalName));
        }
        return this.loginWasDoneWithSuccess;
    }
}

