/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.optim.api.LeafRewriteRule;
import org.objectweb.medor.optim.api.LeafRewriter;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class JormLeafRewriteRule
extends BasicRule
implements LeafRewriteRule {
    ArrayList leafRewriters = new ArrayList();

    public JormLeafRewriteRule() {
        super("JormLeafRewriteRule");
    }

    public JormLeafRewriteRule(LeafRewriter lr) {
        this();
        this.leafRewriters.add(lr);
    }

    public void addLeafRewriter(LeafRewriter lr) {
        this.leafRewriters.add(lr);
    }

    public void removeLeafRewriter(LeafRewriter lr) {
        this.leafRewriters.add(lr);
    }

    public Collection getLeafRewriters() {
        return this.leafRewriters;
    }

    public LeafRewriter getLeafRewriter(QueryLeaf ql) {
        Iterator it = this.leafRewriters.iterator();
        while (it.hasNext()) {
            LeafRewriter lr = (LeafRewriter)it.next();
            if (!lr.canRewrite(ql)) continue;
            return lr;
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("No LeafRewriter found (among " + this.leafRewriters.size() + ") for this QueryLeaf: " + ql));
        }
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
    }

    public LoggerFactory getLoggerFactory() {
        return null;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public Logger getLogger() {
        return this.log;
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        boolean bl = this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("qt=" + qt));
        }
        if (qt == null) {
            return null;
        }
        ClassExtent extent = null;
        if (qt instanceof ClassExtent) {
            extent = (ClassExtent)qt;
            return this.getLeafRewriter(extent).rewrite(extent);
        }
        Iterator it = this.getLeafUsers(qt).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            extent = (ClassExtent)entry.getKey();
            ArrayList users = (ArrayList)entry.getValue();
            QueryTree neo = this.getLeafRewriter(extent).rewrite(extent);
            Iterator it2 = users.iterator();
            while (it2.hasNext()) {
                int i;
                boolean mustReplace;
                QueryTreeField[] neos;
                Field[] fs;
                Object o = it2.next();
                if (o instanceof FieldOperand) {
                    FieldOperand fo = (FieldOperand)o;
                    fo.setField(neo.getTupleStructure().getField(fo.getField().getName()));
                    continue;
                }
                if (o instanceof PropagatedField) {
                    PropagatedField pf = (PropagatedField)o;
                    fs = pf.getPreviousFields();
                    neos = new QueryTreeField[fs.length];
                    mustReplace = false;
                    for (i = 0; i < fs.length; ++i) {
                        if (fs[i] instanceof QueryTreeField && ((QueryTreeField)fs[i]).getQueryTree() == extent) {
                            mustReplace = true;
                            neos[i] = (QueryTreeField)neo.getTupleStructure().getField(fs[i].getName());
                            continue;
                        }
                        neos[i] = (QueryTreeField)fs[i];
                    }
                    if (!mustReplace) continue;
                    ((QueryNode)pf.getQueryTree()).updatePropagatedField(pf.getName(), neos);
                    continue;
                }
                if (!(o instanceof NestedField)) continue;
                NestedField nf = (NestedField)o;
                fs = nf.getFields();
                neos = new QueryTreeField[fs.length];
                mustReplace = false;
                for (i = 0; i < fs.length; ++i) {
                    if (fs[i] instanceof QueryTreeField && ((QueryTreeField)fs[i]).getQueryTree() == extent) {
                        mustReplace = true;
                        neos[i] = (QueryTreeField)neo.getTupleStructure().getField(fs[i].getName());
                        continue;
                    }
                    neos[i] = (QueryTreeField)fs[i];
                }
                if (!mustReplace) continue;
                ((QueryNode)nf.getQueryTree()).updatePropagatedField(nf.getName(), neos);
            }
        }
        return qt;
    }

    protected Map getLeafUsers(QueryTree qt) throws MedorException {
        HashMap res = new HashMap();
        this.getLeafUsers(qt, res, new ArrayList());
        return res;
    }

    protected void getLeafUsers(QueryTree qt, Map m, ArrayList al) throws MedorException {
        al.add(qt);
        if (qt instanceof FilteredQueryTree) {
            this.getLeafUsers(((FilteredQueryTree)qt).getQueryFilter(), m, al);
        }
        if (!(qt instanceof QueryLeaf)) {
            Field[] fields = qt.getTupleStructure().getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] instanceof PropagatedField) {
                    this.getLeafUsers(((PropagatedField)fields[i]).getPreviousFields(), fields[i], m, al);
                    continue;
                }
                if (fields[i] instanceof CalculatedField) {
                    this.getLeafUsers(((CalculatedField)fields[i]).getExpression(), m, al);
                    continue;
                }
                if (!(fields[i] instanceof NestedField)) continue;
                this.getLeafUsers(((NestedField)fields[i]).getFields(), fields[i], m, al);
            }
        }
    }

    private void getLeafUsers(Expression e, Map m, ArrayList al) throws MedorException {
        if (e instanceof Operator) {
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                this.getLeafUsers(((Operator)e).getExpression(i), m, al);
            }
        } else if (e instanceof FieldOperand) {
            FieldOperand fo = (FieldOperand)e;
            QueryTree qt = ((QueryTreeField)fo.getField()).getQueryTree();
            if (qt instanceof ClassExtent) {
                ArrayList<FieldOperand> users = (ArrayList<FieldOperand>)m.get(qt);
                if (users == null) {
                    users = new ArrayList<FieldOperand>();
                    m.put(qt, users);
                }
                users.add(fo);
            } else if (!al.contains(qt)) {
                this.getLeafUsers(qt, m, al);
            }
        }
    }

    private void getLeafUsers(Field[] usedFields, Object user, Map m, ArrayList al) throws MedorException {
        for (int i = 0; i < usedFields.length; ++i) {
            if (!(usedFields[i] instanceof QueryTreeField)) continue;
            QueryTree qt = ((QueryTreeField)usedFields[i]).getQueryTree();
            if (qt instanceof ClassExtent) {
                ArrayList<Object> users = (ArrayList<Object>)m.get(qt);
                if (users == null) {
                    users = new ArrayList<Object>();
                    m.put(qt, users);
                }
                users.add(user);
                continue;
            }
            if (al.contains(qt)) continue;
            this.getLeafUsers(qt, m, al);
        }
    }
}

