/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.ow2.jonas.ant.JOnASAntTool;
import org.ow2.jonas.ant.cluster.ClusterDaemon;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.cluster.Common;
import org.ow2.jonas.ant.cluster.EjbLevel;
import org.ow2.jonas.ant.cluster.Script;
import org.ow2.jonas.ant.cluster.WebLevel;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JMkdir;
import org.ow2.jonas.ant.jonasbase.Tasks;

public class JOnASClusterConfigTask
extends Task {
    private static final String ARCH_BOTH_WEB_EJB = "bothWebEjb";
    private static final String ARCH_DIFF_WEB_EJB = "diffWebEjb";
    private File jonasRoot = null;
    private String destDirPrefix = null;
    private String cdDir = null;
    private String arch = null;
    private int webInstNb = -1;
    private int ejbInstNb = -1;
    private boolean onlyUpdate = false;
    private List<Task> tasks = new ArrayList<Task>();
    public static final String LOG_DIR_NAME = "logs";
    public static final String DEPLOY_DIR_NAME = "deploy";
    public static final String LIB_EXT_DIR_NAME = "lib/ext";
    public static final String[] DEPLOYMENT_PLAN_LIST = new String[]{"jonasAdmin.xml", "mejb.xml", "ctxroot.xml", "doc.xml"};

    private void createJonasBase(String destDir) {
        File destDirFile = new File(destDir);
        File jprops = new File(destDir + File.separator + "conf" + File.separator + "jonas.properties");
        if (this.onlyUpdate) {
            if (jprops.exists()) {
                this.log("Only updating JONAS_BASE in the directory '" + destDir + "' from source directory '" + this.jonasRoot + "'", 2);
                JOnASAntTool.updateJonasBase(this, this.jonasRoot, destDirFile, DEPLOYMENT_PLAN_LIST);
                return;
            }
            throw new BuildException("JOnAS base directory '" + destDir + "' doesn't exists. Cannot update.");
        }
        this.log("Creating JONAS_BASE in the directory '" + destDir + "' from source directory '" + this.jonasRoot + "'", 2);
        Copy copy = new Copy();
        JOnASAntTool.configure(this, (Task)copy);
        copy.setTodir(destDirFile);
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(new File(this.jonasRoot, "templates"), "conf"));
        copy.addFileset(fileSet);
        copy.setOverwrite(true);
        copy.execute();
        this.log("Creating logs in the directory '" + destDir, 2);
        JMkdir mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(destDir + File.separator + LOG_DIR_NAME));
        mkdir.execute();
        this.log("Creating deploy in the directory '" + destDir, 2);
        mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(destDir + File.separator + DEPLOY_DIR_NAME));
        mkdir.execute();
        this.log("Creating lib/ext in the directory '" + destDir, 2);
        mkdir = new JMkdir();
        JOnASAntTool.configure(this, (Task)mkdir);
        mkdir.setDestDir(new File(destDir + File.separator + LIB_EXT_DIR_NAME));
        mkdir.execute();
    }

    private void updateJonasBase(String destDir) {
        File destDirFile = new File(destDir);
        JOnASAntTool.updateJonasBase(this, this.jonasRoot, destDirFile, DEPLOYMENT_PLAN_LIST);
    }

    public void execute() {
        String destDir;
        if (this.jonasRoot == null) {
            throw new BuildException("jonasRoot element is not set");
        }
        if (this.destDirPrefix == null) {
            throw new BuildException("destDirPrefix element is not set");
        }
        if (this.cdDir == null) {
            throw new BuildException("cdDir element is not set");
        }
        if (this.jonasRoot.getPath().equals(this.destDirPrefix)) {
            throw new BuildException("jonasRoot and destDirPrefix is the same path !");
        }
        for (int i = 1; i <= this.webInstNb + this.ejbInstNb; ++i) {
            destDir = ClusterTasks.getDestDir(this.destDirPrefix, i);
            this.createJonasBase(destDir);
        }
        this.createJonasBase(this.cdDir);
        for (Task task : this.tasks) {
            ((BaseTaskItf)task).setJonasRoot(this.jonasRoot);
            JOnASAntTool.configure(this, task);
            String info = ((BaseTaskItf)task).getLogInfo();
            if (info != null) {
                this.log(info, 2);
            }
            task.execute();
        }
        for (int i = 1; i <= this.webInstNb + this.ejbInstNb; ++i) {
            destDir = ClusterTasks.getDestDir(this.destDirPrefix, i);
            this.updateJonasBase(destDir);
        }
        this.updateJonasBase(this.cdDir);
    }

    public void addTasks(Tasks subTasks) {
        if (subTasks != null) {
            for (Task task : subTasks.getTasks()) {
                this.tasks.add(task);
            }
        }
    }

    public void setDestDirPrefix(String destDirPrefix) {
        this.destDirPrefix = destDirPrefix;
    }

    public void setCdDir(String cdDir) {
        this.cdDir = cdDir;
    }

    public void setJonasRoot(File jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setWebInstNb(int webInstNb) {
        this.webInstNb = webInstNb;
    }

    public void setEjbInstNb(int ejbInstNb) {
        this.ejbInstNb = ejbInstNb;
    }

    public void addConfiguredCommon(Common common) {
        common.setRootTask(this);
        common.setDestDirPrefix(this.destDirPrefix);
        common.setDestDirSuffixIndFirst(1);
        common.setDestDirSuffixIndLast(this.webInstNb + this.ejbInstNb);
        common.setArch(this.arch);
        common.setWebInstNb(this.webInstNb);
        common.setEjbInstNb(this.ejbInstNb);
        common.generatesTasks();
        this.addTasks(common);
    }

    public void addConfiguredWebLevel(WebLevel webLevel) {
        webLevel.setRootTask(this);
        webLevel.setDestDirPrefix(this.destDirPrefix);
        webLevel.setArch(this.arch);
        if (this.arch.compareTo(ARCH_BOTH_WEB_EJB) == 0) {
            webLevel.setDestDirSuffixIndFirst(1);
            webLevel.setDestDirSuffixIndLast(this.webInstNb + this.ejbInstNb);
        } else if (this.arch.compareTo(ARCH_DIFF_WEB_EJB) == 0) {
            webLevel.setDestDirSuffixIndFirst(1);
            webLevel.setDestDirSuffixIndLast(this.webInstNb);
        } else {
            this.handleErrorOutput("Invalide architecture choice : " + this.arch);
        }
        webLevel.generatesTasks();
        this.addTasks(webLevel);
    }

    public void addConfiguredEjbLevel(EjbLevel ejbLevel) {
        ejbLevel.setRootTask(this);
        ejbLevel.setDestDirPrefix(this.destDirPrefix);
        ejbLevel.setArch(this.arch);
        if (this.arch.compareTo(ARCH_BOTH_WEB_EJB) == 0) {
            ejbLevel.setDestDirSuffixIndFirst(1);
            ejbLevel.setDestDirSuffixIndLast(this.webInstNb + this.ejbInstNb);
        } else if (this.arch.compareTo(ARCH_DIFF_WEB_EJB) == 0) {
            ejbLevel.setDestDirSuffixIndFirst(this.webInstNb + 1);
            ejbLevel.setDestDirSuffixIndLast(this.webInstNb + this.ejbInstNb);
        } else {
            this.handleErrorOutput("Invalide architecture choice : " + this.arch);
        }
        ejbLevel.generatesTasks();
        this.addTasks(ejbLevel);
    }

    public void addConfiguredScript(Script script) {
        script.setRootTask(this);
        script.setLogInfo("Script");
        script.setInstNb(this.webInstNb + this.ejbInstNb);
        script.setDestDirPrefix(this.destDirPrefix);
        script.generatesTasks();
        this.addTasks(script);
    }

    public void addConfiguredClusterDaemon(ClusterDaemon clusterDaemon) {
        clusterDaemon.setRootTask(this);
        clusterDaemon.setLogInfo("ClusterDaemon");
        clusterDaemon.setInstNb(this.webInstNb + this.ejbInstNb);
        clusterDaemon.setDestDirPrefix(this.destDirPrefix);
        clusterDaemon.setJonasRoot(this.jonasRoot.getAbsolutePath());
        clusterDaemon.generatesTasks();
        this.addTasks(clusterDaemon);
    }

    public void setUpdate(boolean onlyUpdate) {
        this.onlyUpdate = onlyUpdate;
    }
}

