/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.type.Type;
import org.slf4j.Logger;

public class ScrollableResultsImpl
implements ScrollableResults {
    private static final Logger log = LoggerFactory.make();
    private final SearchFactory searchFactory;
    private final IndexSearcher searcher;
    private final int first;
    private final int max;
    private final int fetchSize;
    private final Loader loader;
    private final DocumentExtractor documentExtractor;
    private final SessionImplementor session;
    private final LoadedObject[] resultsContext;
    private int current;

    public ScrollableResultsImpl(IndexSearcher searcher, int first, int max, int fetchSize, DocumentExtractor extractor, Loader loader, SearchFactory searchFactory, SessionImplementor sessionImplementor) {
        this.searchFactory = searchFactory;
        this.searcher = searcher;
        this.first = first;
        this.max = max;
        this.loader = loader;
        this.documentExtractor = extractor;
        this.fetchSize = fetchSize;
        this.session = sessionImplementor;
        int size = Math.max(max - first + 1, 0);
        this.resultsContext = new LoadedObject[size];
        this.beforeFirst();
    }

    private LoadedObject ensureCurrentLoaded() {
        LoadedObject currentCacheRef = this.resultsContext[this.current - this.first];
        if (currentCacheRef != null) {
            return currentCacheRef;
        }
        int windowStop = Math.min(this.max + 1, this.current + this.fetchSize);
        int windowStart = Math.max(this.first, this.current - this.fetchSize + 1);
        ArrayList<EntityInfo> entityInfosToLoad = new ArrayList<EntityInfo>(this.fetchSize);
        int sizeToLoad = 0;
        for (int x = windowStart; x < windowStop; ++x) {
            int arrayIdx = x - this.first;
            LoadedObject lo = this.resultsContext[arrayIdx];
            if (lo != null) continue;
            lo = new LoadedObject();
            entityInfosToLoad.add(lo.getEntityInfo(x));
            this.resultsContext[arrayIdx] = lo;
            if (++sizeToLoad >= this.fetchSize) break;
        }
        if (sizeToLoad > 1) {
            this.loader.load(entityInfosToLoad.toArray(new EntityInfo[sizeToLoad]));
        }
        return this.resultsContext[this.current - this.first];
    }

    public boolean next() {
        if (++this.current > this.max) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public boolean previous() {
        if (--this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return true;
    }

    public boolean scroll(int i) {
        this.current += i;
        if (this.current > this.max) {
            this.afterLast();
            return false;
        }
        if (this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return true;
    }

    public boolean last() {
        this.current = this.max;
        if (this.current < this.first) {
            this.beforeFirst();
            return false;
        }
        return this.max >= this.first;
    }

    public boolean first() {
        this.current = this.first;
        if (this.current > this.max) {
            this.afterLast();
            return false;
        }
        return this.max >= this.first;
    }

    public void beforeFirst() {
        this.current = this.first - 1;
    }

    public void afterLast() {
        this.current = this.max + 1;
    }

    public boolean isFirst() {
        return this.current == this.first;
    }

    public boolean isLast() {
        return this.current == this.max;
    }

    public void close() {
        try {
            this.searchFactory.getReaderProvider().closeReader(this.searcher.getIndexReader());
        }
        catch (SearchException e) {
            log.warn("Unable to properly close searcher in ScrollableResults", (Throwable)e);
        }
    }

    public Object[] get() throws HibernateException {
        if (this.current < this.first || this.current > this.max) {
            return null;
        }
        LoadedObject cacheEntry = this.ensureCurrentLoaded();
        return cacheEntry.getManagedResult(this.current);
    }

    public Object get(int i) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Type getType(int i) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Integer getInteger(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Long getLong(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Float getFloat(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Boolean getBoolean(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Double getDouble(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Short getShort(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Byte getByte(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Character getCharacter(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public byte[] getBinary(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getText(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Blob getBlob(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Clob getClob(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getString(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigDecimal getBigDecimal(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigInteger getBigInteger(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Date getDate(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Locale getLocale(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Calendar getCalendar(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public TimeZone getTimeZone(int col) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public int getRowNumber() {
        if (this.max < this.first) {
            return -1;
        }
        return this.current - this.first;
    }

    public boolean setRowNumber(int rowNumber) {
        this.current = rowNumber >= 0 ? this.first + rowNumber : this.max + rowNumber + 1;
        return this.current >= this.first && this.current <= this.max;
    }

    private boolean areAllEntitiesManaged(Object[] objects, EntityInfo entityInfo) {
        Session hibSession = (Session)((Object)this.session);
        if (entityInfo.projection != null) {
            for (int idx : entityInfo.indexesOfThis) {
                Object o = objects[idx];
                if (hibSession.contains(o)) continue;
                return false;
            }
            return true;
        }
        return hibSession.contains(objects[0]);
    }

    private final class LoadedObject {
        private Reference<Object[]> entity;
        private Reference<EntityInfo> einfo;

        private LoadedObject() {
        }

        private Object[] getManagedResult(int x) {
            Object[] objects;
            EntityInfo entityInfo = this.getEntityInfo(x);
            Object[] objectArray = objects = this.entity == null ? null : this.entity.get();
            if (objects != null && ScrollableResultsImpl.this.areAllEntitiesManaged(objects, entityInfo)) {
                return objects;
            }
            Object[] loaded = ScrollableResultsImpl.this.loader.load(entityInfo);
            if (!loaded.getClass().isArray()) {
                loaded = new Object[]{loaded};
            }
            objects = loaded;
            this.entity = new SoftReference<Object[]>(objects);
            return objects;
        }

        private EntityInfo getEntityInfo(int x) {
            EntityInfo entityInfo;
            EntityInfo entityInfo2 = entityInfo = this.einfo == null ? null : this.einfo.get();
            if (entityInfo == null) {
                try {
                    entityInfo = ScrollableResultsImpl.this.documentExtractor.extract(x);
                }
                catch (IOException e) {
                    throw new SearchException("Unable to read Lucene topDocs[" + x + "]", e);
                }
                this.einfo = new SoftReference<EntityInfo>(entityInfo);
            }
            return entityInfo;
        }
    }
}

