/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    static Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    static Field getFieldForName(String fieldName, Class javaClass) {
        Field field;
        block5: {
            field = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        field = (Field)AccessController.doPrivileged(new PrivilegedGetField(javaClass, fieldName, false));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        return null;
                    }
                }
                field = PrivilegedAccessHelper.getField(javaClass, fieldName, false);
            }
            catch (NoSuchFieldException nsfex) {
                return null;
            }
        }
        return field;
    }

    static Field[] getFields(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(cls);
    }

    static Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(cls, methodName, params, true));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    static Method getMethodForPropertyName(String propertyName, Class cls) {
        String leadingChar = String.valueOf(propertyName.charAt(0)).toUpperCase();
        String restOfName = propertyName.substring(1);
        Method method = MetadataHelper.getMethod("get".concat(leadingChar).concat(restOfName), cls, new Class[0]);
        if (method == null) {
            method = MetadataHelper.getMethod("is".concat(leadingChar).concat(restOfName), cls, new Class[0]);
        }
        return method;
    }

    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed(method, target, e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, target, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed(method, target, ex2);
            }
        }
        return null;
    }
}

