/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.Mod;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.expression.lib.Round;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class NamingFilterExpressionHelper
extends CommonHelper {
    public Map field2declarations = new HashMap();
    public StringBuffer filter = new StringBuffer();

    public NamingFilterExpressionHelper(Logger logger) throws PException, ExpressionException {
        this.logger = logger;
    }

    public Map getField2declarations() {
        return this.field2declarations;
    }

    public String getFilter() {
        return this.filter.toString();
    }

    public String toString() {
        return super.toString() + " / filter=" + this.filter.toString() + " / field2declarations=" + this.field2declarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fillMatchInfo(Expression e) throws PException, ExpressionException {
        if (e instanceof Round) {
            PType type = ((Operator)e).getExpression(0).getType();
            if (type != null && (type.getTypeCode() == 6 || type.getTypeCode() == 7)) {
                this.filter.append("java.lang.Math.round(");
                this.fillMatchInfo(((Operator)e).getExpression(0));
                this.filter.append(')');
                return;
            } else {
                this.fillMatchInfo(((Operator)e).getExpression(0));
            }
            return;
        } else if (e instanceof Operator) {
            Operator operator = (Operator)e;
            this.logger.log(BasicLevel.DEBUG, (Object)("Operator " + operator.getOperatorString()));
            int nb = operator.getOperandNumber();
            if (nb == 1) {
                this.filter.append(operator.getOperatorString());
                this.fillMatchInfo(operator.getExpression(0));
                return;
            } else {
                if (nb != 2) throw new PException("Operators with more than 2 operands are not supported: " + e);
                Expression e0 = operator.getExpression(0);
                Expression e1 = operator.getExpression(1);
                String opPreString = "";
                String opString = " " + this.operator2String(operator) + " ";
                String opPostString = "";
                if ((e instanceof Equal || e instanceof NotEqual) && (this.isObjectOperand(e0) || this.isObjectOperand(e1))) {
                    opString = ".equals(";
                    opPostString = ")";
                    if (e instanceof NotEqual) {
                        opPreString = "!";
                    }
                    if (this.isArrayOperand(e0) || this.isArrayOperand(e1)) {
                        opPreString = opPreString + "java.util.Arrays.equals(";
                        opString = ",";
                    }
                } else {
                    if (this.isObjectOperand(e0) && e0 instanceof ParameterOperand) {
                        opString = this.getConverter2Primitif((Operand)e0) + opString;
                    }
                    if (this.isObjectOperand(e1) && e1 instanceof ParameterOperand) {
                        opPostString = this.getConverter2Primitif((Operand)e1) + opPostString;
                    }
                }
                this.filter.append('(');
                this.filter.append(opPreString);
                this.fillMatchInfo(operator.getExpression(0));
                this.filter.append(opString);
                this.fillMatchInfo(operator.getExpression(1));
                this.filter.append(opPostString);
                this.filter.append(')');
            }
            return;
        } else if (e instanceof ParameterOperand) {
            this.fillMatchInfo((ParameterOperand)e);
            return;
        } else {
            if (!(e instanceof Operand) || !((Operand)e).isDefined()) return;
            Operand operand = (Operand)e;
            if (this.isObjectType(operand.getType())) {
                Object o = operand.getObject();
                if (o == null) {
                    this.filter.append("null");
                    return;
                } else {
                    this.filterAppendOperand(operand);
                }
                return;
            } else {
                this.filterAppendOperand(operand);
            }
        }
    }

    private void filterAppendOperand(Operand operand) throws PException, ExpressionException {
        switch (operand.getType().getTypeCode()) {
            case 1: 
            case 9: {
                this.filter.append("'");
                this.filter.append(operand.getChar());
                this.filter.append("'");
                break;
            }
            case 2: 
            case 10: {
                this.filter.append(operand.getByte());
                break;
            }
            case 3: 
            case 11: {
                this.filter.append(operand.getShort());
                break;
            }
            case 4: 
            case 12: {
                this.filter.append(operand.getInt());
                break;
            }
            case 5: 
            case 13: {
                this.filter.append(operand.getLong());
                this.filter.append('l');
                break;
            }
            case 16: {
                this.filter.append('\"');
                this.filter.append(operand.getString());
                this.filter.append('\"');
                break;
            }
            case 19: {
                this.filter.append("new byte[]{");
                String sep = "";
                byte[] arrays = operand.getByteArray();
                for (int i = 0; i < arrays.length; ++i) {
                    this.filter.append(sep);
                    sep = ",";
                    this.filter.append(arrays[i]);
                }
                this.filter.append("}");
                break;
            }
            case 18: {
                char[] arrays = operand.getCharArray();
                this.filter.append("new char[]{");
                String sep = "";
                for (int i = 0; i < arrays.length; ++i) {
                    this.filter.append(sep);
                    sep = ",";
                    this.filter.append(arrays[i]);
                }
                this.filter.append("}");
                break;
            }
            case 17: {
                this.filter.append("new java.util.Date(");
                this.filter.append(operand.getDate().getTime());
                this.filter.append(')');
                break;
            }
            case 22: {
                this.filter.append("new java.math.BigDecimal(\"");
                this.filter.append(operand.getBigDecimal().toString());
                this.filter.append("\")");
                break;
            }
            case 21: {
                this.filter.append("new java.math.BigInteger(\"");
                this.filter.append(operand.getBigDecimal().toString());
                this.filter.append("\")");
                break;
            }
        }
    }

    private boolean isObjectOperand(Expression e) {
        return e instanceof Operand && this.isObjectType(e.getType());
    }

    private boolean isArrayOperand(Expression e) {
        return e instanceof Operand && (e.getType().getTypeCode() == 18 || e.getType().getTypeCode() == 19);
    }

    protected String operator2String(Operator op) {
        if (op instanceof Mod) {
            return "%";
        }
        return op.getOperatorString();
    }

    protected abstract void fillMatchInfo(ParameterOperand var1) throws PException, ExpressionException;

    private String getConverter2Primitif(Operand operand) throws PException, ExpressionException {
        switch (operand.getType().getTypeCode()) {
            case 9: {
                return ".charValue()";
            }
            case 10: {
                return ".bytevalue()";
            }
            case 11: {
                return ".shortValue()";
            }
            case 12: {
                return ".intValue()";
            }
            case 13: {
                return ".longValue()";
            }
        }
        return "";
    }
}

