/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrException;
import org.apache.solr.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final Logger log = Logger.getLogger(SolrCore.class.getName());
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private Document doc;
    private String prefix;
    private String name;
    private static final String project = "solr";
    private static final String base = "org.apache.solr";
    private static final String[] packages = new String[]{"", "analysis.", "schema.", "search.", "update.", "core.", "request.", "handler.", "util."};
    private static String instanceDir;
    private static ClassLoader classLoader;

    public Config(String name, InputStream is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        this.name = name;
        this.prefix = prefix;
        if (prefix != null && !prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.parse(is);
        try {
            DOMUtil.substituteSystemProperties(this.doc);
        }
        catch (SolrException e) {
            SolrException.log(log, "Error in " + name, e);
            throw e;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public XPath getXPath() {
        return xpathFactory.newXPath();
    }

    private String normalize(String path) {
        return this.prefix == null || path.startsWith("/") ? path : this.prefix + path;
    }

    public Object evaluate(String path, QName type) {
        XPath xpath = xpathFactory.newXPath();
        try {
            String xstr = this.normalize(path);
            Object o = xpath.evaluate(xstr, this.doc, type);
            return o;
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + path + " for " + this.name, (Throwable)e, false);
        }
    }

    public Node getNode(String path, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        Node nd = null;
        String xstr = this.normalize(path);
        try {
            nd = (Node)xpath.evaluate(xstr, this.doc, XPathConstants.NODE);
            if (nd == null) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.fine(this.name + " missing optional " + path);
                return null;
            }
            log.finest(this.name + ":" + path + "=" + nd);
            return nd;
        }
        catch (XPathExpressionException e) {
            SolrException.log(log, "Error in xpath", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e, false);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Throwable e) {
            SolrException.log(log, "Error in xpath", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, e, false);
        }
    }

    public String getVal(String path, boolean errIfMissing) {
        Node nd = this.getNode(path, errIfMissing);
        if (nd == null) {
            return null;
        }
        String txt = DOMUtil.getText(nd);
        log.fine(this.name + ' ' + path + '=' + txt);
        return txt;
    }

    public String get(String path) {
        return this.getVal(path, true);
    }

    public String get(String path, String def) {
        String val = this.getVal(path, false);
        return val != null ? val : def;
    }

    public int getInt(String path) {
        return Integer.parseInt(this.getVal(path, true));
    }

    public int getInt(String path, int def) {
        String val = this.getVal(path, false);
        return val != null ? Integer.parseInt(val) : def;
    }

    public boolean getBool(String path) {
        return Boolean.parseBoolean(this.getVal(path, true));
    }

    public boolean getBool(String path, boolean def) {
        String val = this.getVal(path, false);
        return val != null ? Boolean.parseBoolean(val) : def;
    }

    public float getFloat(String path) {
        return Float.parseFloat(this.getVal(path, true));
    }

    public float getFloat(String path, float def) {
        String val = this.getVal(path, false);
        return val != null ? Float.parseFloat(val) : def;
    }

    public static Class findClass(String cname, String ... subpackages) {
        ClassLoader loader = Config.getClassLoader();
        if (subpackages.length == 0) {
            subpackages = packages;
        }
        try {
            return Class.forName(cname, true, loader);
        }
        catch (ClassNotFoundException e) {
            String newName = cname;
            if (newName.startsWith(project)) {
                newName = cname.substring(project.length() + 1);
            }
            for (String subpackage : subpackages) {
                try {
                    String name = "org.apache.solr." + subpackage + newName;
                    log.finest("Trying class name " + name);
                    return Class.forName(name, true, loader);
                }
                catch (ClassNotFoundException e1) {
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading class '" + cname + "'", (Throwable)e, false);
        }
    }

    public static Object newInstance(String cname, String ... subpackages) {
        Class clazz = Config.findClass(cname, subpackages);
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class " + clazz, (Throwable)e, false);
        }
    }

    private static String normalizeDir(String path) {
        if (path == null) {
            return null;
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + '/';
        }
        return path;
    }

    public static void setInstanceDir(String dir) {
        instanceDir = Config.normalizeDir(dir);
        classLoader = null;
        log.info("Solr home set to '" + instanceDir + "'");
    }

    public static String getInstanceDir() {
        if (!Config.isInstanceDirInitialized()) {
            String prop;
            String home = null;
            try {
                InitialContext c = new InitialContext();
                home = (String)c.lookup("java:comp/env/solr/home");
                log.info("Using JNDI solr.home: " + home);
            }
            catch (NoInitialContextException e) {
                log.info("JNDI not configured for Solr (NoInitialContextEx)");
            }
            catch (NamingException e) {
                log.info("No /solr/home in JNDI");
            }
            catch (RuntimeException ex) {
                log.warning("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
            }
            if (home == null && (home = Config.normalizeDir(System.getProperty(prop = "solr.solr.home"))) != null) {
                log.info("using system property solr.home: " + home);
            }
            if (home == null) {
                home = "solr/";
                log.info("Solr home defaulted to '" + instanceDir + "' (could not find system property or JNDI)");
            }
            Config.setInstanceDir(home);
        }
        return instanceDir;
    }

    public static boolean isInstanceDirInitialized() {
        return instanceDir != null;
    }

    static String getConfigDir() {
        return Config.getInstanceDir() + "conf/";
    }

    static ClassLoader getClassLoader() {
        if (null == classLoader) {
            classLoader = Thread.currentThread().getContextClassLoader();
            File f = new File(Config.getInstanceDir() + "lib/");
            if (f.canRead() && f.isDirectory()) {
                File[] jarFiles = f.listFiles();
                URL[] jars = new URL[jarFiles.length];
                try {
                    for (int j = 0; j < jarFiles.length; ++j) {
                        jars[j] = jarFiles[j].toURI().toURL();
                        log.info("Adding '" + jars[j].toString() + "' to Solr classloader");
                    }
                    classLoader = URLClassLoader.newInstance(jars, classLoader);
                }
                catch (MalformedURLException e) {
                    SolrException.log(log, "Can't construct solr lib class loader", e);
                }
            }
        }
        return classLoader;
    }

    public static InputStream openResource(String resource) {
        InputStream is = null;
        try {
            File f = new File(resource);
            if (!f.isAbsolute()) {
                f = new File(Config.getConfigDir() + resource);
            }
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            f = new File(resource);
            if (f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            ClassLoader loader = Config.getClassLoader();
            is = loader.getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new RuntimeException("Can't find resource '" + resource + "' in classpath or '" + Config.getConfigDir() + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public static List<String> getLines(String resource) throws IOException {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(Config.openResource(resource), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> lines = new ArrayList<String>();
        String word = null;
        while ((word = input.readLine()) != null) {
            if (word.startsWith("#") || (word = word.trim()).length() == 0) continue;
            lines.add(word);
        }
        return lines;
    }

    static {
        classLoader = null;
    }
}

