/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.binder.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.felix.dependencymanager.DefaultNullObject;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFieldValue(Object bean, Field field, Class<T> type) {
        Object value = null;
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                value = field.get(bean);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to get value from the bean '" + bean + "' for the field '" + field + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to get value from the bean '" + bean + "' for the field '" + field + "'.", e);
            }
        }
        finally {
            field.setAccessible(isAccessible);
        }
        return type.cast(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object bean, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(bean, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to inject value '" + value + "' in the bean '" + bean + "' for the field '" + field + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to inject value '" + value + "' in the bean '" + bean + "' for the field '" + field + "'.", e);
            }
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void invokeMethod(Method method, Object bean, T value) {
        boolean isAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            try {
                method.invoke(bean, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to call method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to call method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unable to call method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
        }
        finally {
            method.setAccessible(isAccessible);
        }
    }

    public static String getNameFromMethod(Method method) {
        String methodName = method.getName();
        String dependencyName = null;
        if (methodName.startsWith("bind")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "bind");
        } else if (methodName.startsWith("unbind")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "unbind");
        } else if (methodName.startsWith("set")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "set");
        } else if (methodName.startsWith("reset")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "reset");
        } else if (methodName.startsWith("unset")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "unset");
        } else if (methodName.startsWith("add")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "add");
        } else if (methodName.startsWith("remove")) {
            dependencyName = ReflectionHelper.removePrefixFromMethod(methodName, "remove");
        } else {
            throw new IllegalStateException("Unrecognized method name pattern");
        }
        dependencyName = dependencyName.substring(0, 1).toLowerCase().concat(dependencyName.substring(1));
        return dependencyName;
    }

    private static String removePrefixFromMethod(String methodName, String prefix) {
        return methodName.substring(prefix.length());
    }

    public static Class<?> findServiceInterface(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> type = null;
        switch (parameters.length) {
            case 1: {
                type = parameters[0];
                ReflectionHelper.rejectInvalidTypes(type);
                return type;
            }
        }
        throw new IllegalStateException("Needs a service interface Class argument");
    }

    private static void rejectInvalidTypes(Class<?> type) {
        if (type.equals(Object.class) || type.equals(ServiceReference.class)) {
            throw new IllegalStateException("Invalid parameter type: " + type + ". A service interface is required, or serviceInterface should be described in the annotation");
        }
    }

    public static boolean isNullableObject(Object service) {
        InvocationHandler handler;
        boolean isNullObject = false;
        Class<?> itf = service.getClass();
        if (Proxy.isProxyClass(itf) && DefaultNullObject.class.isAssignableFrom((handler = Proxy.getInvocationHandler(service)).getClass())) {
            isNullObject = true;
        }
        return isNullObject;
    }
}

