/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundProducer
implements MessageProducer {
    protected OutboundSession session;
    protected MessageProducer producer;
    boolean valid = true;

    OutboundProducer(MessageProducer producer, OutboundSession session) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundProducer(" + producer + ", " + session + ")"));
        }
        this.producer = producer;
        this.session = session;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkValidity();
        this.producer.setDisableMessageID(value);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkValidity();
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setPriority(int priority) throws JMSException {
        this.checkValidity();
        this.producer.setPriority(priority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkValidity();
        this.producer.setTimeToLive(timeToLive);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkValidity();
        this.producer.setDisableMessageTimestamp(value);
    }

    public Destination getDestination() throws JMSException {
        this.checkValidity();
        return this.producer.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkValidity();
        return this.producer.getDisableMessageID();
    }

    public int getDeliveryMode() throws JMSException {
        this.checkValidity();
        return this.producer.getDeliveryMode();
    }

    public int getPriority() throws JMSException {
        this.checkValidity();
        return this.producer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        this.checkValidity();
        return this.producer.getTimeToLive();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkValidity();
        return this.producer.getDisableMessageTimestamp();
    }

    public void send(Message message) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + message + ")"));
        }
        this.checkValidity();
        this.producer.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination dest, Message message) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + dest + ", " + message + ")"));
        }
        this.checkValidity();
        this.producer.send(dest, message);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " send(" + dest + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(dest, message, deliveryMode, priority, timeToLive);
    }

    public void close() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " close()"));
        }
        this.valid = false;
        this.producer.close();
    }

    protected void checkValidity() throws IllegalStateException {
        this.session.checkValidity();
        if (!this.valid) {
            throw new IllegalStateException("Invalid call on a closed producer.");
        }
    }
}

