/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.jndi2.server.EntryPoint;
import fr.dyade.aaa.jndi2.server.LifeCycleListener;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public class Container
extends Agent
implements BagSerializer {
    private static final long serialVersionUID = 1L;
    private Vector entryPoints = new Vector(2);
    private LifeCycleListener lifeCycleListener;
    private BagSerializer bagSerializer;

    public Container() {
        super("JNDIServer", true, AgentId.LocalJndiServiceStamp);
    }

    public void addEntryPoint(EntryPoint entryPoint) {
        this.entryPoints.addElement(entryPoint);
    }

    public void setLifeCycleListener(LifeCycleListener lifeCycleListener) {
        this.lifeCycleListener = lifeCycleListener;
    }

    public void setBagSerializer(BagSerializer bagSerializer) {
        this.bagSerializer = bagSerializer;
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("\n\nJndiServer[" + this.getId() + "].react(" + from + ',' + not + ')'));
        }
        this.setNoSave();
        for (int i = 0; i < this.entryPoints.size(); ++i) {
            EntryPoint entryPoint = (EntryPoint)this.entryPoints.elementAt(i);
            if (!entryPoint.accept(from, not)) continue;
            return;
        }
        super.react(from, not);
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("\n\nJndiServer[" + this.getId() + "].agentInitialize(" + firstTime + ')'));
        }
        this.lifeCycleListener.agentInitialize(firstTime);
    }

    public void agentFinalize(boolean lastTime) {
        this.lifeCycleListener.agentFinalize(lastTime);
    }

    void sendNotification(AgentId to, Notification not) {
        this.sendTo(to, not);
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        if (this.bagSerializer != null) {
            this.bagSerializer.writeBag(out);
        }
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.bagSerializer != null) {
            this.bagSerializer.readBag(in);
        }
    }
}

