/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.ee.validation;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.spec.ee.validation.ValidationProviderResolverHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProviderActivator
implements BundleActivator,
ValidationProviderResolver,
ServiceListener {
    private ValidationProviderResolver previousValidationProviderResolver = null;
    private List<ValidationProvider<?>> validationProviders = new ArrayList();
    private BundleContext bundleContext = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.previousValidationProviderResolver = ValidationProviderResolverHolder.getValidationProviderResolver();
        ValidationProviderResolverHolder.setValidationProviderResolver(this);
        ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(ValidationProvider.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                ValidationProvider validationProvider = (ValidationProvider)this.bundleContext.getService(serviceReference);
                this.validationProviders.add(validationProvider);
            }
        }
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + ValidationProvider.class.getName() + ")");
    }

    public void stop(BundleContext context) throws Exception {
        ValidationProviderResolverHolder.setValidationProviderResolver(this.previousValidationProviderResolver);
    }

    public void clearCachedProviders() {
        this.validationProviders.clear();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        ValidationProvider validationProvider = (ValidationProvider)this.bundleContext.getService(serviceRef);
        switch (event.getType()) {
            case 1: {
                this.validationProviders.add(validationProvider);
                break;
            }
            case 4: {
                this.validationProviders.remove(validationProvider);
                break;
            }
        }
    }

    @Override
    public List<ValidationProvider<?>> getValidationProviders() {
        return this.validationProviders;
    }
}

