/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ant.archive;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.ow2.util.ant.archive.info.ArchiveInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsArchive
extends Task {
    private File deploymentDescriptor = null;
    private File specificDeploymentDescriptor = null;
    private File dest = null;
    private String name = null;
    private boolean exploded = false;
    private List<FileSet> fileSetList = new ArrayList<FileSet>();
    private File manifest = null;

    public void addFileSet(ZipFileSet zipFileSet) {
        this.fileSetList.add((FileSet)zipFileSet);
    }

    public List<FileSet> getFileSetList() {
        return this.fileSetList;
    }

    public void setExploded(boolean exploded) {
        this.exploded = exploded;
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public void setDD(File dd) {
        if ("empty-value".equals(dd.getName())) {
            return;
        }
        if (!dd.exists()) {
            throw new BuildException("The given file '" + dd + "' for the deployment descriptor does not exist.");
        }
        this.deploymentDescriptor = dd;
    }

    public void setSpecificDD(File dd) {
        if ("empty-value".equals(dd.getName())) {
            return;
        }
        if (!dd.exists()) {
            throw new BuildException("The given file '" + dd + "' for the deployment descriptor does not exist.");
        }
        this.specificDeploymentDescriptor = dd;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public File getDest() {
        return this.dest;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        if (!manifest.exists()) {
            throw new BuildException("The given file '" + manifest + "' for the MANIFEST does not exist.");
        }
        this.manifest = manifest;
    }

    protected void updateArchiveInfo(ArchiveInfo archiveInfo) {
        archiveInfo.setDest(this.dest);
        archiveInfo.setDD(this.deploymentDescriptor);
        archiveInfo.setSpecificDD(this.specificDeploymentDescriptor);
        archiveInfo.setExploded(this.exploded);
        archiveInfo.setManifest(this.manifest);
        for (FileSet fileSet : this.getFileSetList()) {
            archiveInfo.addFileSet(fileSet);
        }
    }
}

