/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.util.state.Transition;

public class State {
    private String name;
    private HashMap allowedTransitions = new HashMap();
    private Object data;

    public State(String name) {
        this(name, null);
    }

    public State(String name, Map transitions) {
        this.name = name;
        if (transitions != null) {
            this.allowedTransitions.putAll(transitions);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isAcceptState() {
        return this.allowedTransitions.size() == 0;
    }

    public void addTransition(Transition transition) {
        this.allowedTransitions.put(transition.getName(), transition);
    }

    public Transition getTransition(String name) {
        Transition t = (Transition)this.allowedTransitions.get(name);
        return t;
    }

    public Map getTransitions() {
        return this.allowedTransitions;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("State(name=");
        tmp.append(this.name);
        Iterator i = this.allowedTransitions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            tmp.append("\n\t on: ");
            tmp.append(e.getKey());
            Transition t = (Transition)e.getValue();
            tmp.append(" go to: ");
            tmp.append(t.getTarget().getName());
        }
        tmp.append(')');
        return tmp.toString();
    }
}

