/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.util.Map;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.session.SessionMessageImpl;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ClusterSessionListener
extends ClusterListener {
    private static final Log log = LogFactory.getLog(ClusterSessionListener.class);
    protected static final String info = "org.apache.catalina.session.ClusterSessionListener/1.1";

    public String getInfo() {
        return info;
    }

    public void messageReceived(ClusterMessage myobj) {
        if (myobj != null && myobj instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)myobj;
            String ctxname = msg.getContextName();
            Map managers = this.cluster.getManagers();
            if (ctxname == null) {
                for (String key : managers.keySet()) {
                    ClusterManager mgr = (ClusterManager)managers.get(key);
                    if (mgr != null) {
                        mgr.messageDataReceived(msg);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Context manager doesn't exist:" + key);
                }
            } else {
                ClusterManager mgr = (ClusterManager)managers.get(ctxname);
                if (mgr != null) {
                    mgr.messageDataReceived(msg);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn("Context manager doesn't exist:" + ctxname);
                    }
                    if (msg.getEventType() == 4) {
                        SessionMessageImpl replymsg = new SessionMessageImpl(ctxname, 16, null, "NO-CONTEXT-MANAGER", "NO-CONTEXT-MANAGER-" + ctxname);
                        this.cluster.send(replymsg, msg.getAddress());
                    }
                }
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionMessage;
    }
}

