/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private static final Log log = LogFactory.getLog(ApplicationFilterConfig.class);
    private transient Context context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    private transient InstanceManager instanceManager;
    private ObjectName oname;

    ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        this.context = context;
        this.setFilterDef(filterDef);
        if (filterDef.getFilter() != null) {
            this.filter = filterDef.getFilter();
            this.getInstanceManager().newInstance(this.filter);
            this.initFilter();
        }
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getFilterClass() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String name) {
        Map<String, String> map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        Map<String, String> map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator<String>(new ArrayList());
        }
        return new Enumerator<String>(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    public Map<String, String> getFilterInitParameterMap() {
        return Collections.unmodifiableMap(this.filterDef.getParameterMap());
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        if (this.filter != null) {
            return this.filter;
        }
        String filterClass = this.filterDef.getFilterClass();
        this.filter = (Filter)this.getInstanceManager().newInstance(filterClass);
        this.initFilter();
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFilter() throws ServletException {
        if (this.context instanceof StandardContext && this.context.getSwallowOutput()) {
            try {
                SystemLogHandler.startCapture();
                this.filter.init((FilterConfig)this);
            }
            finally {
                String capturedlog = SystemLogHandler.stopCapture();
                if (capturedlog != null && capturedlog.length() > 0) {
                    this.getServletContext().log(capturedlog);
                }
            }
        } else {
            this.filter.init((FilterConfig)this);
        }
        this.registerJMX();
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        this.unregisterJMX();
        if (this.filter != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                }
                catch (Exception ex) {
                    this.context.getLogger().error("ApplicationFilterConfig.doAsPrivilege", ex);
                }
                SecurityUtil.remove(this.filter);
            } else {
                this.filter.destroy();
            }
            if (!this.context.getIgnoreAnnotations()) {
                try {
                    ((StandardContext)this.context).getInstanceManager().destroyInstance(this.filter);
                }
                catch (Exception e) {
                    this.context.getLogger().error("ApplicationFilterConfig.preDestroy", e);
                }
            }
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                    }
                    catch (Exception ex) {
                        this.context.getLogger().error("ApplicationFilterConfig.doAsPrivilege", ex);
                    }
                    SecurityUtil.remove(this.filter);
                } else {
                    this.filter.destroy();
                }
                if (!this.context.getIgnoreAnnotations()) {
                    try {
                        ((StandardContext)this.context).getInstanceManager().destroyInstance(this.filter);
                    }
                    catch (Exception e) {
                        this.context.getLogger().error("ApplicationFilterConfig.preDestroy", e);
                    }
                }
            }
            this.filter = null;
        } else if (filterDef.getFilter() == null) {
            this.getFilter();
        }
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            this.instanceManager = this.context instanceof StandardContext ? ((StandardContext)this.context).getInstanceManager() : new DefaultInstanceManager(null, new HashMap<String, Map<String, String>>(), this.context, this.getClass().getClassLoader());
        }
        return this.instanceManager;
    }

    private void registerJMX() {
        String hostName;
        String parentName = this.context.getName();
        if (!parentName.startsWith("/")) {
            parentName = "/" + parentName;
        }
        hostName = (hostName = this.context.getParent().getName()) == null ? "DEFAULT" : hostName;
        String domain = this.context.getParent().getParent().getName();
        String webMod = "//" + hostName + parentName;
        String onameStr = null;
        if (this.context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)this.context;
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod + ",J2EEApplication=" + standardContext.getJ2EEApplication() + ",J2EEServer=" + standardContext.getJ2EEServer();
        } else {
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod;
        }
        try {
            this.oname = new ObjectName(onameStr);
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
        }
        catch (Exception ex) {
            log.info(sm.getString("applicationFilterConfig.jmxRegisterFail", this.getFilterClass(), this.getFilterName()), ex);
        }
    }

    private void unregisterJMX() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("applicationFilterConfig.jmxUnregister", this.getFilterClass(), this.getFilterName()));
                }
            }
            catch (Exception ex) {
                log.error(sm.getString("applicationFilterConfig.jmxUnregisterFail", this.getFilterClass(), this.getFilterName()), ex);
            }
        }
    }
}

