/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jca.workmanager;

import java.util.LinkedList;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBWorkManagerComponent;
import org.ow2.easybeans.component.itf.TMComponent;
import org.ow2.easybeans.component.jca.workmanager.ResourceWork;
import org.ow2.easybeans.component.jca.workmanager.ResourceWorkManagerStoppedException;
import org.ow2.easybeans.component.jca.workmanager.ResourceWorkThread;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ResourceWorkManagerComponent
implements EZBWorkManagerComponent,
WorkManager {
    public static final long ONE_SECOND = 1000L;
    private static final long DEFAULT_WAIT_TIME = 60000L;
    private static final int DEFAULT_MIN = 5;
    private static final int DEFAULT_MAX = 100;
    private static Log logger = LogFactory.getLog(ResourceWorkManagerComponent.class);
    private LinkedList<ResourceWork> workList = new LinkedList();
    private static int poolnumber = 0;
    private static int threadnumber = 0;
    private int maxpoolsz = 100;
    private int minpoolsz = 5;
    private int poolsz;
    private int freeThreads = 0;
    private long waitingTime = 60000L;
    private boolean stopped = false;
    private static final long FEW_MORE_SECONDS = 3000L;
    private TMComponent transactionComponent = null;

    public ResourceWorkManagerComponent() {
        ++poolnumber;
    }

    public int getCurrentPoolSize() {
        return this.poolsz;
    }

    public int getMinPoolSize() {
        return this.minpoolsz;
    }

    public int getMaxPoolSize() {
        return this.maxpoolsz;
    }

    public void setMinPoolSize(int minsz) {
        this.minpoolsz = minsz;
    }

    public void setMaxPoolSize(int maxsz) {
        this.maxpoolsz = maxsz;
    }

    public void doWork(Work work) throws WorkRejectedException, WorkCompletedException, WorkException {
        this.doMyWork(work, Long.MAX_VALUE, null, null, 0L);
    }

    public void doWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkCompletedException, WorkException {
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        }
        this.doMyWork(work, timeout, executionContext, workListener, System.currentTimeMillis());
    }

    public long startWork(Work work) throws WorkRejectedException, WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkException {
        ResourceWork resourceWork = new ResourceWork(work, timeout, executionContext, workListener);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        }
        long starttime = System.currentTimeMillis();
        long duration = 0L;
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            this.workList.add(resourceWork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, threadnumber++, poolnumber);
                resourceWorkThread.start();
            } else {
                this.workList.notify();
            }
        }
        boolean started = false;
        Object object = resourceWork;
        synchronized (object) {
            if (!resourceWork.isStarted()) {
                try {
                    long waittime = this.waitingTime;
                    if (timeout < waittime) {
                        waittime = timeout + 3000L;
                    }
                    resourceWork.wait(waittime);
                }
                catch (InterruptedException e) {
                    throw new WorkRejectedException("Interrupted");
                }
            }
            started = resourceWork.isStarted();
        }
        duration = System.currentTimeMillis() - starttime;
        if (!started) {
            object = this.workList;
            synchronized (object) {
                if (!this.workList.remove(resourceWork)) {
                    logger.debug((Object)"Cannot remove the work", new Object[0]);
                }
                throw new WorkRejectedException("1");
            }
        }
        return duration;
    }

    public void scheduleWork(Work work) throws WorkRejectedException, WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener) throws WorkRejectedException, WorkException {
        ResourceWork resourceWork = new ResourceWork(work, timeout, executionContext, workListener);
        if (workListener != null) {
            workListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        }
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            this.workList.add(resourceWork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, threadnumber++, poolnumber);
                resourceWorkThread.start();
            } else {
                this.workList.notify();
            }
        }
    }

    private void doMyWork(Work work, long timeout, ExecutionContext executionContext, WorkListener workListener, long creationTime) throws WorkException {
        if (workListener != null) {
            long duration = System.currentTimeMillis() - creationTime;
            if (duration > timeout) {
                logger.warn((Object)"REJECTED: duration= {0}", new Object[]{duration});
                workListener.workRejected(new WorkEvent((Object)this, 2, work, null));
                return;
            }
            workListener.workStarted(new WorkEvent((Object)this, 3, work, null));
        }
        Xid xid = null;
        if (executionContext != null && (xid = executionContext.getXid()) != null) {
            long txtimeout = executionContext.getTransactionTimeout();
            try {
                if (txtimeout != -1L) {
                    this.transactionComponent.begin(xid, txtimeout);
                } else {
                    this.transactionComponent.begin(xid);
                }
            }
            catch (NotSupportedException e) {
                throw new WorkException("Error starting a new transaction", (Throwable)e);
            }
            catch (SystemException e) {
                throw new WorkException("Error starting a new transaction", (Throwable)e);
            }
        }
        try {
            work.run();
            if (workListener != null) {
                workListener.workCompleted(new WorkEvent((Object)this, 4, work, null));
            }
        }
        catch (Exception e) {
            if (workListener != null) {
                workListener.workCompleted(new WorkEvent((Object)this, 4, work, null));
            }
            throw new WorkCompletedException((Throwable)e);
        }
        finally {
            if (xid != null) {
                this.transactionComponent.clearThreadTx();
            }
        }
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextWork() throws WorkException, InterruptedException, ResourceWorkManagerStoppedException {
        ResourceWork run = null;
        boolean haswait = false;
        LinkedList<ResourceWork> linkedList = this.workList;
        synchronized (linkedList) {
            while (this.workList.isEmpty()) {
                if (haswait && this.freeThreads > this.minpoolsz || this.stopped) {
                    --this.poolsz;
                    throw new ResourceWorkManagerStoppedException("Manager is stopped");
                }
                try {
                    ++this.freeThreads;
                    this.workList.wait(this.waitingTime);
                    --this.freeThreads;
                    haswait = true;
                }
                catch (InterruptedException e) {
                    --this.freeThreads;
                    --this.poolsz;
                    throw e;
                }
            }
            ResourceWork resourceWork = run = this.workList.removeFirst();
            synchronized (resourceWork) {
                logger.debug((Object)"Starting a new work", new Object[0]);
                run.setStarted();
                run.notify();
            }
        }
        this.doMyWork(run.getWork(), run.getTimeout(), run.getExecutionContext(), run.getWorkListener(), run.getCreationTime());
    }

    public synchronized void stopThreads() {
        this.stopped = true;
        this.notifyAll();
        --poolnumber;
    }

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        if (this.transactionComponent == null) {
            logger.error((Object)"Component disabled as there is no transaction manager available", new Object[0]);
            this.minpoolsz = 0;
            this.maxpoolsz = 0;
            return;
        }
        this.poolsz = 0;
        while (this.poolsz < this.minpoolsz) {
            ResourceWorkThread resourceWorkThread = new ResourceWorkThread(this, poolnumber, threadnumber++);
            resourceWorkThread.setDaemon(true);
            resourceWorkThread.start();
            ++this.poolsz;
        }
        logger.info((Object)"Settings: minThreads={0},maxThreads={1},txTimeout={2}s", new Object[]{this.minpoolsz, this.maxpoolsz, this.waitingTime / 1000L});
    }

    public void stop() throws EZBComponentException {
        this.stopThreads();
        logger.info((Object)"WorkManager Stopped", new Object[0]);
    }

    public TMComponent getTransactionComponent() {
        return this.transactionComponent;
    }

    public void setTransactionComponent(TMComponent transactionComponent) {
        this.transactionComponent = transactionComponent;
    }
}

