/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tm.jotm.mbean;

import javax.transaction.xa.Xid;
import org.ow2.jonas.lib.management.javaee.J2EEResource;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.tm.jotm.JOTMTransactionService;

public class JTAResource
extends J2EEResource {
    public static final String SERVICE_NAME = "jtm";
    static final String TIMEOUT = "jonas.service.jtm.timeout";
    private long sequenceNumber = 0L;
    private Integer timeOut;
    private Integer portNumber;
    private String hostName;
    private Boolean localJtm;
    private JOTMTransactionService jtm;

    public JTAResource(String objectName, JOTMTransactionService jtm, Integer timeOut, Boolean localJtm, Integer portNumber, String hostName) {
        super(objectName);
        this.jtm = jtm;
        this.timeOut = timeOut;
        this.localJtm = localJtm;
        this.portNumber = portNumber;
        this.hostName = hostName;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
        this.jtm.setTimeout(timeOut);
        this.sendReconfigNotification(++this.sequenceNumber, SERVICE_NAME, new PropertiesConfigurationData(TIMEOUT, timeOut.toString()));
    }

    public Boolean isLocalJtm() {
        return this.localJtm;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void saveConfig() {
        this.sendSaveNotification(++this.sequenceNumber, SERVICE_NAME);
    }

    public Integer getTotalBegunTransactions() {
        return new Integer(this.jtm.getTotalBegunTransactions());
    }

    public Integer getTotalCommittedTransactions() {
        return new Integer(this.jtm.getTotalCommittedTransactions());
    }

    public Integer getTotalCurrentTransactions() {
        return new Integer(this.jtm.getTotalCurrentTransactions());
    }

    public Integer getTotalExpiredTransactions() {
        return new Integer(this.jtm.getTotalExpiredTransactions());
    }

    public Integer getTotalRolledbackTransactions() {
        return new Integer(this.jtm.getTotalRolledbackTransactions());
    }

    public void resetAllCounters() {
        this.jtm.resetAllTxTotalCounters();
    }

    public Xid[] getAllActiveXids() {
        return this.jtm.getAllActiveXids();
    }

    public String[] getAllActiveTx() {
        String[] mysArray = this.jtm.getAllActiveTx();
        return mysArray;
    }

    public String[] getAllRecoveryTx() {
        String[] mysArray = this.jtm.getAllRecoveryTx();
        return mysArray;
    }

    public String[] getAllXAResource(String xatx) {
        String[] mysArray = this.jtm.getAllXAResource(xatx);
        return mysArray;
    }

    public int commitXAResource(String xatx) {
        int commiterror = this.jtm.commitXAResource(xatx);
        return commiterror;
    }

    public int rollbackXAResource(String xatx) {
        int rollbackerror = this.jtm.rollbackXAResource(xatx);
        return rollbackerror;
    }

    public int forgetXAResource(String xatx) {
        int forgeterror = this.jtm.forgetXAResource(xatx);
        return forgeterror;
    }
}

