/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.internal.realm.factory.JResourceDS;
import org.ow2.jonas.security.internal.realm.factory.JResourceLDAP;
import org.ow2.jonas.security.internal.realm.factory.JResourceMemory;
import org.ow2.jonas.security.realm.factory.JResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JResources {
    private Hashtable<String, JResource> jResources = new Hashtable();
    private SecurityService service = null;
    private JmxService jmxService = null;
    private String domainName = null;
    public static final String HEADER_XML = "<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n";

    public void addJResource(JResource jResource) throws Exception {
        if (this.jResources.get(jResource.getName()) != null) {
            throw new Exception("The resource name " + jResource.getName() + " already exists !");
        }
        this.jResources.put(jResource.getName(), jResource);
        jResource.setJmxService(this.jmxService);
        jResource.setDomainName(this.domainName);
        jResource.setSecurityService(this.service);
        this.service.bindResource(jResource.getName(), jResource);
    }

    public JResource remove(String resourceName) throws Exception {
        JResource jResource = this.jResources.get(resourceName);
        if (jResource == null) {
            throw new Exception("The resource name " + resourceName + " doesn't exist !");
        }
        this.jResources.remove(resourceName);
        return jResource;
    }

    public JResource getJResource(String name) {
        return this.jResources.get(name);
    }

    public Enumeration<JResource> getResources() {
        return this.jResources.elements();
    }

    public String toXML() {
        JResource o;
        StringBuffer xml = new StringBuffer(HEADER_XML);
        xml.append("<!--\n");
        xml.append(" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n");
        xml.append(" - Define a jonas-realm.xml file for JOnAS realms\n");
        xml.append(" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n");
        xml.append(" -->\n");
        xml.append("<jonas-realm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  MEMORY REALM =-\n");
        xml.append("       Define the users, groups and roles\n");
        xml.append("  -->\n");
        xml.append("  <jonas-memoryrealm>\n");
        Enumeration<JResource> e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceMemory)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-memoryrealm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  DATASOURCE REALM =-\n");
        xml.append("       Define the configuration to use datas from a datasource\n");
        xml.append("  -->\n");
        xml.append("  <jonas-dsrealm>\n");
        e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceDS)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-dsrealm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  LDAP REALM =-\n");
        xml.append("       Define the configuration to use datas from an ldap server\n");
        xml.append("  -->\n");
        xml.append("  <jonas-ldaprealm>\n");
        e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceLDAP)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-ldaprealm>\n");
        xml.append("</jonas-realm>\n");
        return xml.toString();
    }

    public void setSecurityService(SecurityService service) {
        this.service = service;
    }

    public void setDomainName(String domain) {
        this.domainName = domain;
    }

    public void setJmxService(JmxService jmx) {
        this.jmxService = jmx;
    }

    public boolean hasJmxService() {
        return this.jmxService != null;
    }
}

