/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class ChannelConcurrencyTest
extends TestCase {
    public void testPlainChannel() throws Throwable {
        this.testhelper(false);
    }

    public void testwithDispatcher() throws Throwable {
        this.testhelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testhelper(boolean useDispatcher) throws Throwable {
        int count = 8;
        ExecutorService executor = Executors.newFixedThreadPool(8);
        CountDownLatch latch = new CountDownLatch(8);
        JChannel[] channels = new JChannel[8];
        Task[] tasks = new Task[8];
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            channels[i] = new JChannel("flush-udp.xml");
            tasks[i] = new Task(latch, channels[i], useDispatcher);
            ChannelConcurrencyTest.changeMergeInterval(channels[i]);
            ChannelConcurrencyTest.changeViewBundling(channels[i]);
        }
        for (Task t : tasks) {
            executor.execute(t);
        }
        try {
            latch.await();
            for (Task t : tasks) {
                Throwable ex = t.getException();
                if (ex == null) continue;
                throw ex;
            }
            boolean converged = false;
            int timeoutToConverge = 160;
            for (int counter = 0; counter < timeoutToConverge && !converged; ++counter) {
                JChannel[] arr$ = channels;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    JChannel channel = arr$[i$];
                    boolean bl = converged = channel.getView().size() == 8;
                    if (!converged) break;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            long duration = System.currentTimeMillis() - start;
            System.out.println("Converged to a single group after " + duration + " ms; group is:\n");
            for (int i = 0; i < channels.length; ++i) {
                System.out.println("#" + (i + 1) + ": " + channels[i].getLocalAddress() + ": " + channels[i].getView());
            }
            for (JChannel channel : channels) {
                ChannelConcurrencyTest.assertSame((String)("View ok for channel " + channel.getLocalAddress()), (Object)8, (Object)channel.getView().size());
            }
            Object var17_22 = null;
            System.out.print("closing channels: ");
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            System.out.print("closing channels: ");
            for (int i = channels.length - 1; i >= 0; --i) {
                JChannel channel = channels[i];
                ((Channel)channel).close();
                Util.sleep(300L);
                int tries = 0;
                while ((((Channel)channel).isConnected() || ((Channel)channel).isOpen()) && tries++ < 10) {
                    Util.sleep(1000L);
                }
            }
            System.out.println("OK");
            for (JChannel channel : channels) {
                ChannelConcurrencyTest.assertFalse((String)"Channel connected", (boolean)channel.isConnected());
            }
            throw throwable;
        }
        for (int i = channels.length - 1; i >= 0; --i) {
            JChannel channel = channels[i];
            ((Channel)channel).close();
            Util.sleep(300L);
            int tries = 0;
            while ((((Channel)channel).isConnected() || ((Channel)channel).isOpen()) && tries++ < 10) {
                Util.sleep(1000L);
            }
        }
        System.out.println("OK");
        for (JChannel channel : channels) {
            ChannelConcurrencyTest.assertFalse((String)"Channel connected", (boolean)channel.isConnected());
        }
    }

    private static void changeViewBundling(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol(GMS.class);
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(500L);
        }
    }

    private static void changeMergeInterval(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        MERGE2 merge = (MERGE2)stack.findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }

    private static class MyHandler
    implements RequestHandler {
        private MyHandler() {
        }

        public Object handle(Message msg) {
            return msg.getObject();
        }
    }

    private static class Task
    implements Runnable {
        private final Channel c;
        private final CountDownLatch latch;
        private Throwable exception = null;
        private boolean useDispatcher = false;

        public Task(CountDownLatch latch, Channel c, boolean useDispatcher) {
            this.latch = latch;
            this.c = c;
            this.useDispatcher = useDispatcher;
        }

        public Throwable getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block5: {
                    try {
                        if (this.useDispatcher) {
                            MessageDispatcher md = new MessageDispatcher(this.c, null, null, new MyHandler());
                            this.c.connect("test");
                            md.castMessage(null, new Message(null, null, (Serializable)((Object)"blah")), 2, 2500L);
                            break block5;
                        }
                        this.c.connect("test");
                    }
                    catch (Exception e) {
                        this.exception = e;
                        e.printStackTrace();
                        Object var3_4 = null;
                        this.latch.countDown();
                    }
                }
                Object var3_3 = null;
                this.latch.countDown();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.latch.countDown();
                throw throwable;
            }
        }
    }
}

