/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;

class UnionEvaluatedTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC {
    private boolean second = false;
    private TupleCollection leftTCResult;
    private TupleCollection rightTCResult;
    private QueryNode query;

    public UnionEvaluatedTC(QueryNode query, NodeEvaluator leftNodeEvaluator, NodeEvaluator rightNodeEvaluator, ParameterOperand[] parameters) throws MedorException {
        this.query = query;
        this.leftTCResult = leftNodeEvaluator.fetchData(parameters);
        this.rightTCResult = rightNodeEvaluator.fetchData(parameters);
        if (this.leftTCResult.isEmpty()) {
            this.second = true;
        }
    }

    public void close() throws MedorException {
        super.close();
        if (this.leftTCResult != null) {
            this.leftTCResult.close();
        }
        if (this.rightTCResult != null) {
            this.rightTCResult.close();
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.query.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        boolean end = false;
        end = !this.rightTCResult.isEmpty() ? this.rightTCResult.isLast() : this.leftTCResult.isLast();
        return end;
    }

    public boolean next() throws MedorException {
        if (!this.second) {
            if (!this.leftTCResult.next()) {
                this.second = true;
                return !this.rightTCResult.isEmpty();
            }
            return true;
        }
        return this.rightTCResult.next();
    }

    public void first() throws MedorException {
        this.leftTCResult.first();
        this.rightTCResult.first();
        this.second = false;
    }

    public int getRow() throws MedorException {
        if (!this.second) {
            return this.leftTCResult.getRow();
        }
        return this.leftTCResult.getRow() + this.rightTCResult.getRow();
    }

    public Tuple getTuple() throws MedorException {
        if (this.second) {
            return this.rightTCResult.getTuple();
        }
        return this.leftTCResult.getTuple();
    }

    public Tuple getTuple(int row) throws MedorException {
        if (row <= 0) {
            throw new MedorException("Invalid Tuple index: " + row);
        }
        try {
            return this.leftTCResult.getTuple(row);
        }
        catch (MedorException me) {
            return this.rightTCResult.getTuple(row - this.getLeftCard());
        }
    }

    private int getLeftCard() {
        return 0;
    }

    public boolean isEmpty() throws MedorException {
        return this.leftTCResult.isEmpty() & this.rightTCResult.isEmpty();
    }

    public boolean row(int numTuple) throws MedorException {
        this.first();
        int cpt = 1;
        boolean go = true;
        while (cpt <= numTuple && cpt > 1 && go) {
            if (this.next()) continue;
            go = false;
        }
        return go;
    }

    public synchronized int getLeftTCCursor() throws MedorException {
        return this.leftTCResult.getRow();
    }

    public synchronized int getRightTCCursor() throws MedorException {
        return this.rightTCResult.getRow();
    }
}

