/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.AccessLog;
import org.apache.catalina.CatalinaFactory;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class ContainerBase
extends LifecycleMBeanBase
implements Container {
    private static final Log log = LogFactory.getLog(ContainerBase.class);
    protected HashMap<String, Container> children = new HashMap();
    protected int backgroundProcessorDelay = -1;
    protected ArrayList<ContainerListener> listeners = new ArrayList();
    protected Loader loader = null;
    protected Log logger = null;
    protected String logName = null;
    protected Manager manager = null;
    protected Cluster cluster = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = CatalinaFactory.getFactory().createPipeline(this);
    protected Realm realm = null;
    protected DirContext resources = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean startChildren = true;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private volatile boolean threadDone = false;
    protected volatile AccessLog accessLog = null;
    private volatile boolean accessLogScanComplete = false;

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    @Override
    public Loader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    @Override
    public synchronized void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        if (oldLoader == loader) {
            return;
        }
        this.loader = loader;
        if (this.getState().isAvailable() && oldLoader != null && oldLoader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldLoader)).stop();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setLoader: stop: ", e);
            }
        }
        if (loader != null) {
            loader.setContainer(this);
        }
        if (this.getState().isAvailable() && loader != null && loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader)).start();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setLoader: start: ", e);
            }
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    @Override
    public Log getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        this.logger = LogFactory.getLog(this.logName());
        return this.logger;
    }

    @Override
    public Manager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    @Override
    public synchronized void setManager(Manager manager) {
        Manager oldManager = this.manager;
        if (oldManager == manager) {
            return;
        }
        this.manager = manager;
        if (this.getState().isAvailable() && oldManager != null && oldManager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldManager)).stop();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setManager: stop: ", e);
            }
        }
        if (manager != null) {
            manager.setContainer(this);
        }
        if (this.getState().isAvailable() && manager != null && manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager)).start();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setManager: start: ", e);
            }
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Object getMappingObject() {
        return this;
    }

    @Override
    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.parent != null) {
            return this.parent.getCluster();
        }
        return null;
    }

    @Override
    public synchronized void setCluster(Cluster cluster) {
        Cluster oldCluster = this.cluster;
        if (oldCluster == cluster) {
            return;
        }
        this.cluster = cluster;
        if (this.getState().isAvailable() && oldCluster != null && oldCluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldCluster)).stop();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setCluster: stop: ", e);
            }
        }
        if (cluster != null) {
            cluster.setContainer(this);
        }
        if (this.getState().isAvailable() && cluster != null && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setCluster: start: ", e);
            }
        }
        this.support.firePropertyChange("cluster", oldCluster, this.cluster);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean getStartChildren() {
        return this.startChildren;
    }

    public void setStartChildren(boolean startChildren) {
        boolean oldStartChildren = this.startChildren;
        this.startChildren = startChildren;
        this.support.firePropertyChange("startChildren", oldStartChildren, this.startChildren);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Realm getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    @Override
    public synchronized void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        if (oldRealm == realm) {
            return;
        }
        this.realm = realm;
        if (this.getState().isAvailable() && oldRealm != null && oldRealm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldRealm)).stop();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setRealm: stop: ", e);
            }
        }
        if (realm != null) {
            realm.setContainer(this);
        }
        if (this.getState().isAvailable() && realm != null && realm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.setRealm: start: ", e);
            }
        }
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    @Override
    public DirContext getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        DirContext oldResources = this.resources;
        if (oldResources == resources) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        this.resources = new ProxyDirContext(env, resources);
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    @Override
    public void addChild(Container child) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container child) {
        if (log.isDebugEnabled()) {
            log.debug("Add child " + child + " " + this);
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + child.getName() + "' is not unique");
            }
            child.setParent(this);
            this.children.put(child.getName(), child);
        }
        if ((this.getState().isAvailable() || LifecycleState.STARTING_PREP.equals((Object)this.getState())) && this.startChildren) {
            boolean success = false;
            try {
                child.start();
                success = true;
            }
            catch (LifecycleException e) {
                log.error("ContainerBase.addChild: start: ", e);
                throw new IllegalStateException("ContainerBase.addChild: start: " + e);
            }
            finally {
                if (!success) {
                    HashMap<String, Container> hashMap2 = this.children;
                    synchronized (hashMap2) {
                        this.children.remove(child.getName());
                    }
                }
            }
        }
        this.fireContainerEvent("addChild", child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            return this.children.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container[] findChildren() {
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            Container[] results = new Container[this.children.size()];
            return this.children.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerListener[] findContainerListeners() {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            ContainerListener[] results = new ContainerListener[this.listeners.size()];
            return this.listeners.toArray(results);
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.getFirst().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container child) {
        if (child == null) {
            return;
        }
        HashMap<String, Container> hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) == null) {
                return;
            }
            this.children.remove(child.getName());
        }
        try {
            if (child.getState().isAvailable()) {
                child.stop();
            }
        }
        catch (LifecycleException e) {
            log.error("ContainerBase.removeChild: stop: ", e);
        }
        this.fireContainerEvent("removeChild", child);
        try {
            if (!LifecycleState.DESTROYING.equals((Object)child.getState())) {
                child.destroy();
            }
        }
        catch (LifecycleException e) {
            log.error("ContainerBase.removeChild: destroy: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        this.logger = null;
        this.getLogger();
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].start();
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.setState(LifecycleState.STARTING);
        this.threadStart();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.threadStop();
        this.setState(LifecycleState.STOPPING);
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].stop();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).destroy();
        }
        for (Container child : this.findChildren()) {
            this.removeChild(child);
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        super.destroyInternal();
    }

    @Override
    public void logAccess(Request request, Response response, long time, boolean useDefault) {
        boolean logged = false;
        if (this.getAccessLog() != null) {
            this.getAccessLog().log(request, response, time);
            logged = true;
        }
        if (this.getParent() != null) {
            this.getParent().logAccess(request, response, time, useDefault && !logged);
        }
    }

    @Override
    public AccessLog getAccessLog() {
        Valve[] valves;
        if (this.accessLogScanComplete) {
            return this.accessLog;
        }
        for (Valve valve : valves = this.getPipeline().getValves()) {
            if (!(valve instanceof AccessLog)) continue;
            this.accessLog = (AccessLog)((Object)valve);
            break;
        }
        this.accessLogScanComplete = true;
        return this.accessLog;
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
    }

    @Override
    public void backgroundProcess() {
        if (!this.getState().isAvailable()) {
            return;
        }
        if (this.cluster != null) {
            try {
                this.cluster.backgroundProcess();
            }
            catch (Exception e) {
                log.warn(sm.getString("containerBase.backgroundProcess.cluster", this.cluster), e);
            }
        }
        if (this.loader != null) {
            try {
                this.loader.backgroundProcess();
            }
            catch (Exception e) {
                log.warn(sm.getString("containerBase.backgroundProcess.loader", this.loader), e);
            }
        }
        if (this.manager != null) {
            try {
                this.manager.backgroundProcess();
            }
            catch (Exception e) {
                log.warn(sm.getString("containerBase.backgroundProcess.manager", this.manager), e);
            }
        }
        if (this.realm != null) {
            try {
                this.realm.backgroundProcess();
            }
            catch (Exception e) {
                log.warn(sm.getString("containerBase.backgroundProcess.realm", this.realm), e);
            }
        }
        for (Valve current = this.pipeline.getFirst(); current != null; current = current.getNext()) {
            try {
                current.backgroundProcess();
                continue;
            }
            catch (Exception e) {
                log.warn(sm.getString("containerBase.backgroundProcess.valve", current), e);
            }
        }
        this.fireLifecycleEvent("periodic", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireContainerEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent event = new ContainerEvent(this, type, data);
        ContainerListener[] list = new ContainerListener[]{};
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].containerEvent(event);
        }
    }

    protected String logName() {
        if (this.logName != null) {
            return this.logName;
        }
        String loggerName = null;
        for (Container current = this; current != null; current = current.getParent()) {
            String name = current.getName();
            if (name == null || name.equals("")) {
                name = "/";
            } else if (name.startsWith("##")) {
                name = "/" + name;
            }
            loggerName = "[" + name + "]" + (loggerName != null ? "." + loggerName : "");
        }
        this.logName = ContainerBase.class.getName() + "." + loggerName;
        return this.logName;
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    public ObjectName[] getChildren() {
        ObjectName[] result = new ObjectName[this.children.size()];
        Iterator<Container> it = this.children.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            Container next = it.next();
            if (!(next instanceof ContainerBase)) continue;
            result[i++] = ((ContainerBase)next).getObjectName();
        }
        return result;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            while (!ContainerBase.this.threadDone) {
                try {
                    Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (ContainerBase.this.threadDone) continue;
                Container parent = (Container)ContainerBase.this.getMappingObject();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (parent.getLoader() != null) {
                    cl = parent.getLoader().getClassLoader();
                }
                this.processChildren(parent, cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader cl) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                container.backgroundProcess();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error("Exception invoking periodic operation: ", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Container[] children = container.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(children[i], cl);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction<Void> {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        @Override
        public Void run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

