/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.LinkedCacheKey;

public class CacheIdentityMap
extends FullIdentityMap {
    protected LinkedCacheKey first = new LinkedCacheKey(new CacheId(new Object[0]), null, null, 0L);
    protected LinkedCacheKey last = new LinkedCacheKey(new CacheId(new Object[0]), null, null, 0L);

    public CacheIdentityMap(int size) {
        super(size);
        this.first.setNext(this.last);
        this.last.setPrevious(this.first);
    }

    public CacheIdentityMap(int size, ClassDescriptor descriptor) {
        super(size, descriptor);
        this.first.setNext(this.last);
        this.last.setPrevious(this.first);
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new LinkedCacheKey(primaryKey, object, writeLockValue, readTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFixedSize() {
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            while (this.getMaxSize() > 0 && this.getSize() > this.getMaxSize()) {
                this.remove(this.last.getPrevious());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKey(Object primaryKeys) {
        LinkedCacheKey cacheKey = (LinkedCacheKey)super.getCacheKey(primaryKeys);
        if (cacheKey != null) {
            LinkedCacheKey linkedCacheKey = this.first;
            synchronized (linkedCacheKey) {
                this.removeLink(cacheKey);
                this.insertLink(cacheKey);
            }
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey insertLink(LinkedCacheKey key) {
        if (key == null) {
            return key;
        }
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            this.first.getNext().setPrevious(key);
            key.setNext(this.first.getNext());
            key.setPrevious(this.first);
            this.first.setNext(key);
        }
        return key;
    }

    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        CacheKey cacheKey = super.putCacheKeyIfAbsent(searchKey);
        if (cacheKey == null) {
            this.insertLink((LinkedCacheKey)searchKey);
            this.ensureFixedSize();
        }
        return cacheKey;
    }

    public Object remove(CacheKey key) {
        super.remove(key);
        if (key == null) {
            return null;
        }
        return this.removeLink((LinkedCacheKey)key).getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedCacheKey removeLink(LinkedCacheKey key) {
        if (key == null) {
            return key;
        }
        LinkedCacheKey linkedCacheKey = this.first;
        synchronized (linkedCacheKey) {
            if (key.getPrevious() == null || key.getNext() == null) {
                return key;
            }
            key.getPrevious().setNext(key.getNext());
            key.getNext().setPrevious(key.getPrevious());
            key.setNext(null);
            key.setPrevious(null);
        }
        return key;
    }

    public synchronized void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
        this.ensureFixedSize();
    }
}

