/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCJavaFieldImpl
implements JavaField {
    private JFieldVar xjcField;
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private static Field JVAR_ANNOTATIONS = null;
    private static Field JFIELDVAR_OWNER = null;

    public XJCJavaFieldImpl(JFieldVar javaField, JCodeModel codeModel, DynamicClassLoader loader) {
        this.xjcField = javaField;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = null;
            try {
                annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JVAR_ANNOTATIONS, this.xjcField);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (annotations == null) {
                return null;
            }
            for (JAnnotationUse annotationUse : annotations) {
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                if (!xjcAnnotation.getJavaAnnotationClass().getCanonicalName().equals(aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = null;
        try {
            annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JVAR_ANNOTATIONS, this.xjcField);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public int getModifiers() {
        return this.xjcField.mods().getValue();
    }

    @Override
    public String getName() {
        return this.xjcField.name();
    }

    public JavaClass getOwningClass() {
        JDefinedClass ownerXJCClass = null;
        try {
            ownerXJCClass = (JDefinedClass)PrivilegedAccessHelper.getValueFromField(JFIELDVAR_OWNER, this.xjcField);
        }
        catch (Exception e) {
            return null;
        }
        return new XJCJavaClassImpl(ownerXJCClass, this.jCodeModel, this.dynamicClassLoader);
    }

    @Override
    public JavaClass getResolvedType() {
        JType type = this.xjcField.type();
        JClass basis = null;
        try {
            Field basisField = PrivilegedAccessHelper.getDeclaredField(type.getClass(), "basis", true);
            basis = (JClass)PrivilegedAccessHelper.getValueFromField(basisField, type);
        }
        catch (Exception e) {
            // empty catch block
        }
        JClass classToReturn = null;
        if (type.isPrimitive()) {
            JPrimitiveType pType = (JPrimitiveType)type;
            classToReturn = pType.boxify();
        } else if (type.getClass().getName().contains("JArrayClass")) {
            classToReturn = (JClass)type;
        } else {
            try {
                classToReturn = this.jCodeModel._class(basis != null ? basis.fullName() : type.fullName());
            }
            catch (JClassAlreadyExistsException ex) {
                classToReturn = this.jCodeModel._getClass(basis != null ? basis.fullName() : type.fullName());
            }
        }
        if (basis != null) {
            try {
                Field argsField = PrivilegedAccessHelper.getDeclaredField(type.getClass(), "args", true);
                List args = (List)PrivilegedAccessHelper.getValueFromField(argsField, type);
                for (JClass jClass : args) {
                    ((JDefinedClass)classToReturn).generify("param", jClass);
                }
            }
            catch (Exception e) {
                throw JAXBException.errorCreatingDynamicJAXBContext(e);
            }
        }
        if (classToReturn instanceof JDefinedClass) {
            return new XJCJavaClassImpl((JDefinedClass)classToReturn, this.jCodeModel, this.dynamicClassLoader);
        }
        return new XJCJavaClassImpl(classToReturn, this.jCodeModel, this.dynamicClassLoader);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public boolean isEnumConstant() {
        return this.getOwningClass().isEnum();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass aClass) {
        return this.getAnnotation(aClass);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    static {
        try {
            JVAR_ANNOTATIONS = PrivilegedAccessHelper.getDeclaredField(JVar.class, "annotations", true);
            JFIELDVAR_OWNER = PrivilegedAccessHelper.getDeclaredField(JFieldVar.class, "owner", true);
        }
        catch (Exception e) {
            throw JAXBException.errorCreatingDynamicJAXBContext(e);
        }
    }
}

