/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https_jetty;

import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http_jetty.JettyConnectorFactory;
import org.apache.cxf.transport.https_jetty.CXFJettySslSocketConnector;
import org.eclipse.jetty.server.AbstractConnector;

public final class JettySslConnectorFactory
implements JettyConnectorFactory {
    private static final long serialVersionUID = 1L;
    TLSServerParameters tlsServerParameters;

    public JettySslConnectorFactory(TLSServerParameters params) {
        this.tlsServerParameters = params;
    }

    public AbstractConnector createConnector(int port) {
        return this.createConnector(null, port);
    }

    public AbstractConnector createConnector(String host, int port) {
        assert (this.tlsServerParameters != null);
        CXFJettySslSocketConnector secureConnector = new CXFJettySslSocketConnector();
        if (host != null) {
            secureConnector.setHost(host);
        }
        secureConnector.setPort(port);
        this.decorateCXFJettySslSocketConnector(secureConnector);
        return secureConnector;
    }

    private void decorateCXFJettySslSocketConnector(CXFJettySslSocketConnector con) {
        con.setKeyManagers(this.tlsServerParameters.getKeyManagers());
        con.setTrustManagers(this.tlsServerParameters.getTrustManagers());
        con.setSecureRandom(this.tlsServerParameters.getSecureRandom());
        con.setClientAuthentication(this.tlsServerParameters.getClientAuthentication());
        con.setProtocol(this.tlsServerParameters.getSecureSocketProtocol());
        con.setProvider(this.tlsServerParameters.getJsseProvider());
        con.setCipherSuites(this.tlsServerParameters.getCipherSuites());
        con.setCipherSuitesFilter(this.tlsServerParameters.getCipherSuitesFilter());
    }
}

