/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ws.policy.AssertionBuilderLoader;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderLoader;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.builder.xml.XMLPrimitiveAssertionBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.builders.AlgorithmSuiteBuilder;
import org.apache.cxf.ws.security.policy.builders.AsymmetricBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.ContentEncryptedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.EncryptedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.EncryptedPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.HttpsTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.InitiatorTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.IssuedTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.KeyValueTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.LayoutBuilder;
import org.apache.cxf.ws.security.policy.builders.ProtectionTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.RecipientTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.RequiredElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.RequiredPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.SecureConversationTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.SecurityContextTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.SignedElementsBuilder;
import org.apache.cxf.ws.security.policy.builders.SignedPartsBuilder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokens12Builder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokensBuilder;
import org.apache.cxf.ws.security.policy.builders.SymmetricBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportBindingBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.Trust10Builder;
import org.apache.cxf.ws.security.policy.builders.Trust13Builder;
import org.apache.cxf.ws.security.policy.builders.UsernameTokenBuilder;
import org.apache.cxf.ws.security.policy.builders.WSS10Builder;
import org.apache.cxf.ws.security.policy.builders.WSS11Builder;
import org.apache.cxf.ws.security.policy.builders.X509TokenBuilder;
import org.apache.cxf.ws.security.policy.interceptors.HttpsTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.IssuedTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.UsernameTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityPolicyInterceptorProvider;

@NoJSR250Annotations
public final class WSSecurityPolicyLoader
implements PolicyInterceptorProviderLoader,
AssertionBuilderLoader {
    Bus bus;

    WSSecurityPolicyLoader(Bus b) {
        this.bus = b;
        this.registerBuilders();
        try {
            this.registerProviders();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerBuilders() {
        AssertionBuilderRegistry reg = this.bus.getExtension(AssertionBuilderRegistry.class);
        if (reg == null) {
            return;
        }
        PolicyBuilder pbuild = this.bus.getExtension(PolicyBuilder.class);
        reg.register(new AlgorithmSuiteBuilder());
        reg.register(new AsymmetricBindingBuilder(pbuild));
        reg.register(new ContentEncryptedElementsBuilder());
        reg.register(new EncryptedElementsBuilder());
        reg.register(new EncryptedPartsBuilder());
        reg.register(new HttpsTokenBuilder(pbuild));
        reg.register(new InitiatorTokenBuilder(pbuild));
        reg.register(new IssuedTokenBuilder(pbuild));
        reg.register(new LayoutBuilder());
        reg.register(new ProtectionTokenBuilder(pbuild));
        reg.register(new RecipientTokenBuilder(pbuild));
        reg.register(new RequiredElementsBuilder());
        reg.register(new RequiredPartsBuilder());
        reg.register(new SecureConversationTokenBuilder(pbuild));
        reg.register(new SecurityContextTokenBuilder());
        reg.register(new SignedElementsBuilder());
        reg.register(new SignedPartsBuilder());
        reg.register(new SupportingTokens12Builder(pbuild));
        reg.register(new SupportingTokensBuilder(pbuild));
        reg.register(new SymmetricBindingBuilder(pbuild));
        reg.register(new TransportBindingBuilder(pbuild));
        reg.register(new TransportTokenBuilder(pbuild));
        reg.register(new Trust10Builder());
        reg.register(new Trust13Builder());
        reg.register(new UsernameTokenBuilder(pbuild));
        reg.register(new KeyValueTokenBuilder());
        reg.register(new WSS10Builder());
        reg.register(new WSS11Builder());
        reg.register(new X509TokenBuilder(pbuild));
        List<QName> others = Arrays.asList(SP12Constants.INCLUDE_TIMESTAMP, SP11Constants.INCLUDE_TIMESTAMP, SP12Constants.ENCRYPT_SIGNATURE, SP11Constants.ENCRYPT_SIGNATURE, SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY, new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "OnlySignEntireHeadersAndBody"), SP12Constants.WSS_X509_V1_TOKEN_10, SP12Constants.WSS_X509_V1_TOKEN_11, SP12Constants.WSS_X509_V3_TOKEN_10, SP12Constants.WSS_X509_V3_TOKEN_11, SP11Constants.WSS_X509_V1_TOKEN_10, SP11Constants.WSS_X509_V1_TOKEN_11, SP11Constants.WSS_X509_V3_TOKEN_10, SP11Constants.WSS_X509_V3_TOKEN_11, SP12Constants.WSS_X509_PKCS7_TOKEN_11, SP12Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP11Constants.WSS_X509_PKCS7_TOKEN_11, SP11Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP12Constants.REQUIRE_THUMBPRINT_REFERENCE, SP11Constants.REQUIRE_THUMBPRINT_REFERENCE, SP12Constants.REQUIRE_DERIVED_KEYS, SP11Constants.REQUIRE_DERIVED_KEYS, new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "EncryptBeforeSigning"), new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "EncryptBeforeSigning"));
        reg.register(new XMLPrimitiveAssertionBuilder(others));
    }

    public void registerProviders() {
        PolicyInterceptorProviderRegistry reg = this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (reg == null) {
            return;
        }
        reg.register(new WSSecurityPolicyInterceptorProvider());
        reg.register(new WSSecurityInterceptorProvider());
        reg.register(new HttpsTokenInterceptorProvider());
        reg.register(new IssuedTokenInterceptorProvider());
        reg.register(new UsernameTokenInterceptorProvider(this.bus));
        reg.register(new SecureConversationTokenInterceptorProvider());
    }
}

