/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl.jmx;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ListeningChecker
extends Thread {
    private static final int WAITING = 1000;
    private Logger logger = Logger.getLogger(ListeningChecker.class.getName());
    private ObjectName listening;
    private NotificationListener listener;
    private boolean running = true;
    private MBeanServer jmxServer = null;

    public ListeningChecker(ObjectName listening, NotificationListener listener) {
        this.listening = listening;
        this.listener = listener;
    }

    public void setJMXServer(MBeanServer jmxServer) {
        this.jmxServer = jmxServer;
    }

    public void run() {
        this.logger.log(Level.INFO, "Waiting for " + this.listening.getCanonicalName() + " registration ...");
        while (this.running) {
            try {
                if (this.jmxServer != null && this.jmxServer.isRegistered(this.listening)) {
                    this.jmxServer.addNotificationListener(this.listening, this.listener, null, null);
                    this.logger.log(Level.INFO, this.listening.getCanonicalName() + " is now registered for audit logging.");
                    this.running = false;
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
            try {
                ListeningChecker.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
        }
    }
}

