/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.jonas.launcher.felix.IConfigurationProvider;
import org.ow2.jonas.launcher.felix.JOnAS;
import org.ow2.jonas.launcher.felix.VersionNumber;
import org.ow2.jonas.launcher.felix.util.IOUtils;
import org.ow2.jonas.launcher.felix.util.JOnASUtils;
import org.ow2.jonas.launcher.felix.util.Maven2Utils;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationProvider
implements IConfigurationProvider {
    private static final String FELIX_BUNDLES_CONFIG_FILE_PROP = "jonas.felix.bundles.configuration.file";
    private static final Logger LOGGER = Logger.getLogger(DefaultConfigurationProvider.class.getName());
    private ISubstitutionEngine substitutionEngine;
    private ChainedResolver resolver = new ChainedResolver();

    public DefaultConfigurationProvider() {
        this.substitutionEngine = this.createSubstitutionEngine();
    }

    protected ISubstitutionEngine createSubstitutionEngine() {
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        engine.setMarkerChar('$');
        engine.setOpeningChar('{');
        engine.setEndingChar('}');
        engine.setResolver(new RecursiveResolver(engine, this.resolver));
        return engine;
    }

    @Override
    public Map<?, ?> getConfiguration() throws IOException {
        Properties javaProfiles = IOUtils.getPropertiesFromClass("javase-profiles.properties", JOnAS.class);
        this.resolver.getResolvers().add(new PropertiesResolver(System.getProperties()));
        this.resolver.getResolvers().add(new PropertiesResolver(javaProfiles));
        this.resolveProperties(javaProfiles);
        File defaultsFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/osgi/defaults.properties");
        Properties defaultsProperties = defaultsFile.exists() ? IOUtils.getPropertiesFromFile(defaultsFile) : IOUtils.getPropertiesFromClass("defaults.properties", JOnAS.class);
        defaultsProperties.setProperty("javase.version", DefaultConfigurationProvider.javaSeSpecificationVersion());
        this.resolver.getResolvers().add(new PropertiesResolver(defaultsProperties));
        this.resolveProperties(defaultsProperties);
        File gatewayFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/osgi/gateway.properties");
        Properties gatewayProperties = gatewayFile.exists() ? IOUtils.getPropertiesFromFile(gatewayFile) : IOUtils.getPropertiesFromClass("gateway.properties", JOnAS.class);
        this.resolver.getResolvers().add(new PropertiesResolver(gatewayProperties));
        this.resolveProperties(gatewayProperties);
        this.findAutoDeployedBundles(gatewayProperties);
        File cacheDirectory = IOUtils.getSystemFile(JOnASUtils.getWorkDirectory(), "felix-cache");
        gatewayProperties.put("org.osgi.framework.storage", cacheDirectory.getAbsolutePath());
        return gatewayProperties;
    }

    private void resolveProperties(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            String systemValue = System.getProperty(name);
            if (systemValue != null) {
                value = systemValue;
            }
            String resolved = this.substitutionEngine.substitute(value);
            properties.setProperty(name, resolved);
        }
    }

    private static String javaSeSpecificationVersion() {
        VersionNumber version;
        String value = System.class.getPackage().getSpecificationVersion();
        if (value != null) {
            version = new VersionNumber(value);
        } else {
            value = System.getProperty("java.specification.version", "1.5");
            version = new VersionNumber(value);
        }
        return version.getMajorMinor();
    }

    private void findAutoDeployedBundles(Properties config) throws IOException {
        File cdiBundlesDir;
        String bundleList;
        File jsf2BundlesDir;
        String bundleList2;
        File servlets3BundlesDir;
        String bundleList3;
        File jpa2BundlesDir;
        String bundleList4;
        File file;
        String jonasBootStrapBundlesList;
        Properties levels = null;
        String felixBundlesConfigFilename = System.getProperty(FELIX_BUNDLES_CONFIG_FILE_PROP);
        levels = felixBundlesConfigFilename != null && IOUtils.exists(felixBundlesConfigFilename) ? IOUtils.getPropertiesFromFile(new File(felixBundlesConfigFilename)) : DefaultConfigurationProvider.getAutoDeployedBundles();
        for (String string : levels.keySet()) {
            String level;
            if (string.startsWith("install.level.")) {
                level = string.substring("install.level".length());
                config.put("felix.auto.install".concat(level), this.getBundleList(levels, string));
            }
            if (!string.startsWith("start.level.")) continue;
            level = string.substring("start.level".length());
            config.put("felix.auto.start".concat(level), this.getBundleList(levels, string));
        }
        String newList = (String)config.get("felix.auto.start".concat(".1"));
        if (newList == null) {
            newList = "";
        }
        if (!"".equals(jonasBootStrapBundlesList = this.getBundles(file = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles")))) {
            newList = jonasBootStrapBundlesList.concat(" ").concat(newList);
        }
        String jpaProviders = "";
        try {
            jpaProviders = JOnASUtils.getServerProperty("jonas.service.ejb3.jpa.provider", "");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get ejb3 persistence providers property", e);
        }
        if ((jpaProviders.contains("eclipselink2") || jpaProviders.contains("hibernate3.5") || jpaProviders.contains("openjpa2")) && !"".equals(bundleList4 = this.getBundles(jpa2BundlesDir = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles-jpa2.0")))) {
            newList = bundleList4.concat(" ").concat(newList);
        }
        String webServiceClass = "";
        try {
            webServiceClass = JOnASUtils.getServerProperty("jonas.service.web.class", "");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get jonas.service.web.class property", e);
        }
        if (webServiceClass.contains("7") && !"".equals(bundleList3 = this.getBundles(servlets3BundlesDir = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles-servlets-3.0")))) {
            newList = bundleList3.concat(" ").concat(newList);
        }
        String jsfService = "";
        try {
            jsfService = JOnASUtils.getServerProperty("jonas.service.jsf.class", "");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get JSF service", e);
        }
        if (jsfService.contains("Mojarra20") && !"".equals(bundleList2 = this.getBundles(jsf2BundlesDir = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles-jsf-2.0")))) {
            newList = bundleList2.concat(" ").concat(newList);
        }
        String services = "";
        try {
            services = JOnASUtils.getServerProperty("jonas.services", "");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get 'jonas.services' property in conf/jonas.properties", e);
        }
        List<String> sections = Arrays.asList(services.split(","));
        if (sections.contains("cdi") && !"".equals(bundleList = this.getBundles(cdiBundlesDir = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles-cdi")))) {
            newList = bundleList.concat(" ").concat(newList);
        }
        config.put("felix.auto.start".concat(".1"), newList);
    }

    protected String getBundles(File directory) throws IOException {
        String bundleList = "";
        if (directory.exists()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            File[] bundles = directory.listFiles(filter);
            LOGGER.log(Level.FINE, "Adding bundles from the directory '" + directory + "' :" + Arrays.asList(bundles));
            for (File file : bundles) {
                if (!bundleList.equals("")) {
                    bundleList = bundleList.concat(" ");
                }
                bundleList = bundleList.concat("reference:").concat(file.toURI().toURL().toExternalForm());
            }
        }
        return bundleList;
    }

    private String getBundleList(Properties levels, String key) throws IOException {
        String value = levels.getProperty(key);
        StringBuilder sb = new StringBuilder();
        String[] bundles = value.split(",");
        for (int i = 0; i < bundles.length; ++i) {
            String bundle = bundles[i];
            if ("".equals(bundle)) continue;
            String[] artifact = bundle.split(":");
            String groupId = artifact[0].trim();
            String artifactId = artifact[1].trim();
            String version = null;
            String classifier = null;
            if (artifact.length == 3) {
                classifier = DefaultConfigurationProvider.getClassifier(artifact[2]);
                if (classifier == null) {
                    version = artifact[2].trim();
                }
            } else if (artifact.length == 4) {
                version = artifact[2].trim();
                classifier = DefaultConfigurationProvider.getClassifier(artifact[3]);
                if (classifier == null) {
                    throw new IOException("Incorrect classifier in bundle: " + bundle);
                }
            } else if (artifact.length > 4) {
                throw new IOException("Incorrect number of parts in bundle: " + bundle);
            }
            if (version == null) {
                version = JOnASUtils.getVersion();
            }
            sb.append("reference:");
            File repository = null;
            repository = JOnASUtils.isDeveloperMode() ? Maven2Utils.getMaven2Repository() : Maven2Utils.getMaven2InternalRepository();
            sb.append(Maven2Utils.getBundleMaven2Location(repository.getPath(), groupId, artifactId, version, classifier).concat(" "));
        }
        return sb.toString();
    }

    private static String getClassifier(String value) {
        String classifier = null;
        String trimmed = value.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            classifier = trimmed.substring(1, trimmed.length() - 1);
        }
        return classifier;
    }

    private static Properties getAutoDeployedBundles() throws IOException {
        return IOUtils.getPropertiesFromClass("jonas-autodeploy-bundles.properties", JOnAS.class);
    }
}

