/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.osgi.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.osgi.framework.BundleContext;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.server.IPolicyStrategyManager;
import org.ow2.cmi.controller.server.IServerConfig;
import org.ow2.cmi.lb.loader.ArchiveId;
import org.ow2.cmi.lb.loader.ArchiveWrapper;
import org.ow2.cmi.loader.IArchiveWrapper;
import org.ow2.cmi.loader.IDefaultPolicyStrategyLoader;
import org.ow2.cmi.osgi.loader.LoaderUtil;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DefaultPolicyStrategyLoader
implements IDefaultPolicyStrategyLoader {
    private HashMap<String, String> deployedBundles = new HashMap();
    private static IPolicyStrategyManager policyStrategyManager = null;
    private static BundleContext bundleContext;
    private static final Log LOGGER;

    public static IPolicyStrategyManager getPolicyStrategyManager() {
        return policyStrategyManager;
    }

    public void setPolicyStrategyManager(IPolicyStrategyManager poClusterViewManager) {
        policyStrategyManager = poClusterViewManager;
    }

    public void unLoadClasses(IArchiveWrapper archive) {
    }

    public void unLoadArchive(Object archiveId) {
        String archiveLocation = this.deployedBundles.get(archiveId);
        LOGGER.debug((Object)"Removing bundle with Id {0} installed at {1}", new Object[]{archiveId, archiveLocation});
        File f = new File(archiveLocation);
        if (f.delete()) {
            LOGGER.debug((Object)"The bundle was successfully removed", new Object[0]);
        }
        this.deployedBundles.remove(archiveId);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void setBundleContext(BundleContext bc) {
        bundleContext = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArchive(String deployDir, IArchiveWrapper archive) {
        LOGGER.debug((Object)(" Trying to load classes from archive with id : " + archive.getArchiveId()), new Object[0]);
        ArchiveWrapper arch = (ArchiveWrapper)archive;
        LOGGER.debug((Object)"Getting new archive for load balancing policies/strategies, previously broadcast in the cluster ", new Object[0]);
        ArchiveId archiveId = LoaderUtil.buildArchiveIdFromFormattedId((String)arch.getArchiveId());
        LOGGER.debug((Object)"Archive host:{0} archive location:{1}", new Object[]{archiveId.getHost(), archiveId.getName()});
        if (((ArchiveWrapper)archive).toBeInstalled()) {
            InputStream is = null;
            File archiveTmp = null;
            try {
                archiveTmp = LoaderUtil.createTempJarFile(archiveId.getName(), archive.getData());
                is = archiveTmp.toURL().openStream();
                IServerConfig config = (IServerConfig)ClusterViewManagerFactory.getFactory().getConfig();
                LOGGER.debug((Object)"Deploy dir is {0}", new Object[]{deployDir});
                String deployedLocation = deployDir + archiveTmp.getName();
                File dest = new File(deployDir, archiveId.getName() + ".jar");
                LoaderUtil.dump(is, dest);
                this.deployedBundles.put(archiveId.toString(), deployedLocation);
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Unable to install policy/strategy bundle with Id:{0}, name:{1} because {2}", new Object[]{archiveId.getHost(), archiveId.getName(), e});
            }
            finally {
                if (archiveTmp != null) {
                    archiveTmp.delete();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Unable to close input stream for load balancing archive", new Object[0]);
                    }
                }
            }
        }
        LOGGER.debug((Object)"archive successfully loaded", new Object[0]);
    }

    static {
        LOGGER = LogFactory.getLog(DefaultPolicyStrategyLoader.class);
    }
}

