/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.servlet.JspServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInstanceTldCacheListener
implements InstanceListener {
    private List<URL> resourcesToMonitor = null;

    public OSGiInstanceTldCacheListener(List<URL> resourcesToMonitor) {
        this.resourcesToMonitor = resourcesToMonitor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void instanceEvent(InstanceEvent event) {
        if (!"afterInit".equals(event.getType())) return;
        try {
            JspServlet jspServlet = (JspServlet)event.getServlet();
            Field optionsField = JspServlet.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            EmbeddedServletOptions options = (EmbeddedServletOptions)optionsField.get(jspServlet);
            TldLocationsCache tldLocationCache = options.getTldLocationsCache();
            Method tldScanStreamMethod = TldLocationsCache.class.getDeclaredMethod("tldScanStream", String.class, String.class, InputStream.class);
            tldScanStreamMethod.setAccessible(true);
            if (this.resourcesToMonitor == null) return;
            for (URL url : this.resourcesToMonitor) {
                try {
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setDefaultUseCaches(false);
                    tldScanStreamMethod.invoke((Object)tldLocationCache, url.toString(), null, urlConnection.getInputStream());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to add the TLD", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unable to add the TLD", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Unable to add the TLD", e);
                    return;
                }
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
    }
}

