/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectMemory;
import org.h2.store.fs.FileObjectMemoryData;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.New;

public class FileSystemMemory
extends FileSystem {
    public static final String PREFIX = "memFS:";
    public static final String PREFIX_LZF = "memLZF:";
    private static final FileSystemMemory INSTANCE = new FileSystemMemory();
    private static final TreeMap<String, FileObjectMemoryData> MEMORY_FILES = new TreeMap();

    private FileSystemMemory() {
    }

    public static FileSystemMemory getInstance() {
        return INSTANCE;
    }

    public long length(String string) {
        return this.getMemoryFile(string).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) {
        string = this.getCanonicalPath(string);
        string2 = this.getCanonicalPath(string2);
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileObjectMemoryData fileObjectMemoryData = this.getMemoryFile(string);
            fileObjectMemoryData.setName(string2);
            MEMORY_FILES.remove(string);
            MEMORY_FILES.put(string2, fileObjectMemoryData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile(String string) {
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            if (this.exists(string)) {
                return false;
            }
            this.getMemoryFile(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        string = this.getCanonicalPath(string);
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            return MEMORY_FILES.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string) {
        string = this.getCanonicalPath(string);
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            MEMORY_FILES.remove(string);
        }
    }

    public boolean tryDelete(String string) {
        this.delete(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listFiles(String string) {
        ArrayList<String> arrayList = New.arrayList();
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            for (String string2 : MEMORY_FILES.tailMap(string).keySet()) {
                if (!string2.startsWith(string)) break;
                arrayList.add(string2);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecursive(String string, boolean bl) {
        string = this.getCanonicalPath(string);
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            String string2;
            Iterator<String> iterator = MEMORY_FILES.tailMap(string).keySet().iterator();
            while (iterator.hasNext() && (string2 = iterator.next()).startsWith(string)) {
                iterator.remove();
            }
        }
    }

    public boolean isReadOnly(String string) {
        return !this.getMemoryFile(string).canWrite();
    }

    public boolean setReadOnly(String string) {
        return this.getMemoryFile(string).setReadOnly();
    }

    public String getCanonicalPath(String string) {
        string = string.replace('\\', '/');
        int n = string.indexOf(58) + 1;
        if (string.length() > n && string.charAt(n) != '/') {
            string = string.substring(0, n) + "/" + string.substring(n);
        }
        return string;
    }

    public String getParent(String string) {
        int n = (string = this.getCanonicalPath(string)).lastIndexOf(47);
        if (n < 0) {
            n = string.indexOf(58) + 1;
        }
        return string.substring(0, n);
    }

    public boolean isDirectory(String string) {
        return false;
    }

    public boolean isAbsolute(String string) {
        return true;
    }

    public long getLastModified(String string) {
        return this.getMemoryFile(string).getLastModified();
    }

    public boolean canWrite(String string) {
        return true;
    }

    public void copy(String string, String string2) {
        try {
            OutputStream outputStream = this.openFileOutputStream(string2, false);
            InputStream inputStream = this.openFileInputStream(string);
            IOUtils.copyAndClose(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "Can not copy " + string + " to " + string2);
        }
    }

    public void createDirs(String string) {
    }

    public String getFileName(String string) {
        int n = Math.max(string.indexOf(58), string.lastIndexOf(47));
        return n < 0 ? string : string.substring(n + 1);
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.getCanonicalPath(string);
        string2 = this.getCanonicalPath(string2);
        return string.startsWith(string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        try {
            FileObjectMemoryData fileObjectMemoryData = this.getMemoryFile(string);
            FileObjectMemory fileObjectMemory = new FileObjectMemory(fileObjectMemoryData, false);
            return new FileObjectOutputStream(fileObjectMemory, bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    public InputStream openFileInputStream(String string) {
        FileObjectMemoryData fileObjectMemoryData = this.getMemoryFile(string);
        FileObjectMemory fileObjectMemory = new FileObjectMemory(fileObjectMemoryData, true);
        return new FileObjectInputStream(fileObjectMemory);
    }

    public FileObject openFileObject(String string, String string2) {
        FileObjectMemoryData fileObjectMemoryData = this.getMemoryFile(string);
        return new FileObjectMemory(fileObjectMemoryData, "r".equals(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObjectMemoryData getMemoryFile(String string) {
        string = this.getCanonicalPath(string);
        TreeMap<String, FileObjectMemoryData> treeMap = MEMORY_FILES;
        synchronized (treeMap) {
            FileObjectMemoryData fileObjectMemoryData = MEMORY_FILES.get(string);
            if (fileObjectMemoryData == null) {
                boolean bl = string.startsWith(PREFIX_LZF);
                fileObjectMemoryData = new FileObjectMemoryData(string, bl);
                MEMORY_FILES.put(string, fileObjectMemoryData);
            }
            return fileObjectMemoryData;
        }
    }

    protected boolean accepts(String string) {
        return string.startsWith(PREFIX) || string.startsWith(PREFIX_LZF);
    }

    public String unwrap(String string) {
        return string;
    }
}

