/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.scheduler;

import com.scalagent.scheduler.ScheduleEvent;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class CronEvent
extends ScheduleEvent {
    private static final long serialVersionUID = 1L;
    private static final int CRON_MN = 0;
    private static final int CRON_H = 1;
    private static final int CRON_DOM = 2;
    private static final int CRON_MOY = 3;
    private static final int CRON_DOW = 4;
    private static final int CRON_MAX = 5;
    private static final String[] values = new String[]{"minutes", "hours", "days of month", "months of year", "days of week"};
    private static final int[] min = new int[]{0, 0, 1, 0, 0};
    private static final int[] max = new int[]{59, 23, 31, 11, 6};
    private BitSet[] ranges = new BitSet[5];

    public CronEvent(String name, String date) throws IllegalArgumentException {
        super(name, new Date());
        int i;
        StringTokenizer st = new StringTokenizer(date, " ", false);
        if (st.countTokens() != 5) {
            throw new IllegalArgumentException("Bad number of tokens in cron date");
        }
        String[] sched = new String[5];
        for (i = 0; i < 5; ++i) {
            sched[i] = st.nextToken();
        }
        for (i = 0; i < 5; ++i) {
            String tok = null;
            try {
                this.ranges[i] = new BitSet(max[i] + 1);
                st = new StringTokenizer(sched[i], ",", false);
                while (st.countTokens() > 0) {
                    int j;
                    tok = st.nextToken();
                    if (tok.compareTo("*") == 0) {
                        j = max[i] + 1;
                        while (j-- > 0) {
                            this.ranges[i].set(j);
                        }
                        continue;
                    }
                    j = Integer.parseInt(tok);
                    if (j < min[i] || j > max[i]) {
                        throw new IllegalArgumentException("Bad " + values[i] + " (" + tok + ") in cron date");
                    }
                    this.ranges[i].set(j);
                }
                continue;
            }
            catch (NumberFormatException exc) {
                throw new IllegalArgumentException("Bad " + values[i] + " (" + tok + ") in cron date");
            }
        }
    }

    public StringBuffer toString(StringBuffer output) {
        output.append('(');
        output.append(super.toString(output));
        for (int i = 0; i < 5; ++i) {
            output.append(",");
            output.append(values[i]);
            output.append("=");
            output.append(this.ranges[i]);
        }
        output.append(")");
        return output;
    }

    protected Date nextDate(Date now) {
        long start = now.getTime() + 60000L;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(new Date(start));
        int idx_h = calendar.get(11);
        int idx_mn = calendar.get(12);
        block0: while (true) {
            if (!this.ranges[3].get(calendar.get(2))) {
                calendar.set(5, 1);
                calendar.add(2, 1);
                idx_h = 0;
                idx_mn = 0;
                continue;
            }
            do {
                if (this.ranges[2].get(calendar.get(5)) && this.ranges[4].get(calendar.get(7))) {
                    do {
                        if (this.ranges[1].get(idx_h)) {
                            do {
                                if (this.ranges[0].get(idx_mn)) break block0;
                            } while (++idx_mn <= max[0]);
                        }
                        idx_mn = 0;
                    } while (++idx_h <= max[1]);
                }
                calendar.add(5, 1);
                idx_h = 0;
            } while (calendar.get(5) != 1);
        }
        calendar.set(11, idx_h);
        calendar.set(12, idx_mn);
        this.date = calendar.getTime();
        return this.date;
    }
}

