/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AcquisitionModule;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.AcquisitionTopicMBean;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AcquisitionTopic
extends Topic
implements AcquisitionTopicMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)AcquisitionTopic.class.getName());
    private transient AcquisitionModule acquisitionModule;
    private Properties properties;
    private String lastMessageId;
    private long msgCount = 0L;
    private String acquisitionClassName;

    public String getAcquisitionClassName() {
        return this.acquisitionClassName;
    }

    public AcquisitionTopic() {
        this.fixed = true;
    }

    public void setProperties(Properties properties) throws RequestException {
        super.setProperties(properties);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionTopic.<init> prop = " + properties));
        }
        if (properties == null) {
            throw new RequestException("No property found: At least acquisition.className property must be defined on topic creation.");
        }
        this.properties = properties;
        this.acquisitionClassName = properties.getProperty("acquisition.className");
        properties.remove("acquisition.className");
        try {
            AcquisitionModule.checkAcquisitionClass(this.acquisitionClassName);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionTopic: error with acquisition class.", (Throwable)exc);
            throw new RequestException(exc.getMessage());
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.acquisitionModule == null) {
            this.acquisitionModule = new AcquisitionModule(this, this.acquisitionClassName, this.properties);
        }
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (not instanceof AcquisitionNot) {
            this.acquisitionNot((AcquisitionNot)not);
        } else {
            super.react(from, not);
        }
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        this.close();
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionTopic.preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        this.acquisitionModule.processMessages(cm);
        return null;
    }

    public void updateProperties(Properties prop) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionTopic.updateProperties(" + prop + ')'));
        }
        super.setProperties(prop);
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key, prop.get(key));
        }
        this.acquisitionModule.updateProperties(this.properties);
    }

    protected Properties startHandler(Properties prop) throws Exception {
        Properties p;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionTopic.startHandler(" + prop + ')'));
        }
        if ((p = prop) == null) {
            p = this.properties;
        }
        return this.acquisitionModule.startHandler(p);
    }

    protected Properties stopHandler(Properties prop) throws Exception {
        Properties p;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionTopic.stopHandler(" + prop + ')'));
        }
        if ((p = prop) == null) {
            p = this.properties;
        }
        return this.acquisitionModule.stopHandler(p);
    }

    private void acquisitionNot(AcquisitionNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("acquisitionNot(" + (Object)((Object)not) + ")"));
        }
        if (this.lastMessageId != null && this.lastMessageId.equals(not.getId())) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message already received, drop the message " + (Object)((Object)not)));
            }
            return;
        }
        this.lastMessageId = not.getId();
        ClientMessages clientMessages = this.acquisitionModule.acquisitionNot(not, this.msgCount);
        if (clientMessages != null) {
            this.msgCount += (long)clientMessages.getMessageCount();
            this.forwardMessages(clientMessages);
            this.processMessages(clientMessages);
            this.postProcess(clientMessages);
        }
    }

    public String toString() {
        return "AcquisitionTopic:" + this.getId().toString();
    }

    public long getExpiration() {
        return this.acquisitionModule.getExpiration();
    }

    public int getPriority() {
        return this.acquisitionModule.getPriority();
    }

    public boolean isMessagePersistent() {
        return this.acquisitionModule.isMessagePersistent();
    }

    public void setExpiration(long expiration) {
        this.acquisitionModule.setExpiration(expiration);
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.acquisitionModule.setMessagePersistent(isPersistent);
    }

    public void setPriority(int priority) {
        this.acquisitionModule.setPriority(priority);
    }

    private void close() {
        if (this.acquisitionModule != null) {
            this.acquisitionModule.close();
        }
    }

    public long getAcquisitionPeriod() {
        return this.acquisitionModule.getPeriod();
    }
}

