/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ow2.carol.irmi.Pair;
import org.ow2.carol.irmi.RMIObjectInputStream;
import org.ow2.carol.irmi.RMIObjectOutputStream;
import org.ow2.carol.irmi.Ref;

class Pool {
    private long interval;
    private long timeout;
    private Map entries = new HashMap();

    Pool(long interval, long timeout) {
        this.interval = interval;
        this.timeout = timeout;
        new Reaper().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Pool.this.shutdown();
            }
        });
    }

    Pool() {
        this(30000L, 30000L);
    }

    private Socket connect(String host, int port) throws IOException {
        RMISocketFactory csf = RMISocketFactory.getSocketFactory();
        if (csf == null) {
            csf = RMISocketFactory.getDefaultSocketFactory();
        }
        Socket sock = csf.createSocket(host, port);
        sock.setTcpNoDelay(true);
        sock.setKeepAlive(true);
        return sock;
    }

    public Entry acquire(Ref ref) throws IOException {
        return this.acquire(ref.getHost(), ref.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry acquire(String host, int port) throws IOException {
        Map map = this.entries;
        synchronized (map) {
            Object key = this.key(host, port);
            Entry result = (Entry)this.entries.remove(key);
            if (result == null) {
                result = new Entry(key, this.connect(host, port));
            }
            return result;
        }
    }

    private Object key(String host, int port) {
        return new Pair((Object)host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Entry entry) throws IOException {
        Entry old;
        Map map = this.entries;
        synchronized (map) {
            old = (Entry)this.entries.remove(entry.key);
            this.entries.put(entry.key, entry);
            entry.used = System.currentTimeMillis();
        }
        if (old != null) {
            old.close();
        }
    }

    public void close(Entry entry) {
        entry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map map = this.entries;
        synchronized (map) {
            Iterator it = this.entries.values().iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.close();
                it.remove();
            }
        }
    }

    class Reaper
    extends Thread {
        Reaper() {
            this.setDaemon(true);
            this.setName("IRMI Connection Reaper");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (true) {
                ArrayList values;
                try {
                    Reaper.sleep(Pool.this.interval);
                }
                catch (InterruptedException e) {
                    break;
                }
                Map map = Pool.this.entries;
                synchronized (map) {
                    values = new ArrayList(Pool.this.entries.values());
                }
                Iterator it = values.iterator();
                while (true) {
                    if (!it.hasNext()) continue block8;
                    Entry entry = (Entry)it.next();
                    if (!entry.isExpired()) continue;
                    Entry expired = null;
                    Map map2 = Pool.this.entries;
                    synchronized (map2) {
                        Entry e = (Entry)Pool.this.entries.get(entry.key);
                        if (e.isExpired()) {
                            Pool.this.entries.remove(e.key);
                            expired = e;
                        }
                    }
                    if (expired == null) continue;
                    expired.close();
                }
                break;
            }
        }
    }

    class Entry {
        private Object key;
        private Socket sock;
        private ObjectInputStream in;
        private ObjectOutputStream out;
        private long used;

        private Entry(Object key, Socket sock) throws IOException {
            this.key = key;
            this.sock = sock;
            this.out = new RMIObjectOutputStream(sock.getOutputStream());
            this.in = new RMIObjectInputStream(sock.getInputStream());
            this.used = System.currentTimeMillis();
        }

        public ObjectInputStream getIn() {
            return this.in;
        }

        public ObjectOutputStream getOut() {
            return this.out;
        }

        public Socket getSocket() {
            return this.sock;
        }

        private void close() {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private boolean isExpired() {
            return System.currentTimeMillis() - this.used > Pool.this.timeout;
        }
    }
}

