/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.security.LoginSecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolePrefixSecurityContextImpl
implements LoginSecurityContext {
    private Principal p;
    private Set<Principal> roles;
    private Subject theSubject;

    public RolePrefixSecurityContextImpl(Subject subject, String rolePrefix) {
        this.p = RolePrefixSecurityContextImpl.findPrincipal(subject, rolePrefix);
        this.roles = RolePrefixSecurityContextImpl.findRoles(subject, rolePrefix);
        this.theSubject = subject;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.p;
    }

    @Override
    public boolean isUserInRole(String role) {
        for (Principal principal : this.roles) {
            if (!principal.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    private static Principal findPrincipal(Subject subject, String rolePrefix) {
        for (Principal p : subject.getPrincipals()) {
            if (p.getName().startsWith(rolePrefix)) continue;
            return p;
        }
        return null;
    }

    private static Set<Principal> findRoles(Subject subject, String rolePrefix) {
        HashSet<Principal> set = new HashSet<Principal>();
        for (Principal p : subject.getPrincipals()) {
            if (!p.getName().startsWith(rolePrefix)) continue;
            set.add(p);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Subject getSubject() {
        return this.theSubject;
    }

    @Override
    public Set<Principal> getUserRoles() {
        return this.roles;
    }
}

