/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.IOException;
import java.io.OutputStream;
import org.ow2.carol.irmi.Timer;

public class CountOutputStream
extends OutputStream {
    private static final Timer OUTPUT = new Timer("OUTPUT"){

        public String toString() {
            return super.toString() + " (" + count + " bytes)";
        }
    };
    static int count = 0;
    private OutputStream out;

    private static synchronized void incr(int n) {
        count += n;
    }

    public CountOutputStream(OutputStream os) {
        this.out = os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        OUTPUT.start();
        try {
            this.out.close();
        }
        finally {
            OUTPUT.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        OUTPUT.start();
        try {
            this.out.flush();
        }
        finally {
            OUTPUT.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        OUTPUT.start();
        try {
            this.out.write(b);
        }
        finally {
            OUTPUT.stop();
        }
        CountOutputStream.incr(b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        OUTPUT.start();
        try {
            this.out.write(b, off, len);
        }
        finally {
            OUTPUT.stop();
        }
        CountOutputStream.incr(len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        OUTPUT.start();
        try {
            this.out.write(b);
        }
        finally {
            OUTPUT.stop();
        }
        CountOutputStream.incr(1);
    }
}

