/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CNGenContext;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonJVMHelper;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.naming.api.PExceptionNameCoding;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PNCStringCoder;
import org.objectweb.jorm.naming.lib.BasicStringCoder;
import org.objectweb.jorm.naming.lib.CTHelper;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.lib.StringReplace;
import org.objectweb.util.monolog.api.BasicLevel;

public class BinderGenerator
extends CommonGenerator {
    public static final String ACF_TYPE = "org.objectweb.jorm.facility.naming.generator.LongGen";
    static /* synthetic */ Class class$org$objectweb$jorm$naming$lib$CompositePBinder;

    public void generate(CompositeName co, TargetHolder holder, JormCompilerParameter cp) throws PException {
        ClassWriter cv = new ClassWriter(true);
        BinderGenContext gc = new BinderGenContext(co, cv, this);
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Generate the class '" + gc.classToWrite + "'."));
        }
        cv.visit(196653, 33, gc.classToWrite, gc.compositeBinderJCN, new String[0], gc.classToWrite);
        this.generateNullFields(gc);
        if (gc.hasAutoCalculatedField) {
            this.generateACFieldsNAccessors(gc);
        }
        this.generateNoArgConstructor(gc);
        this.generatePCMConstructor(gc);
        if (gc.allAutoCalculated) {
            this.generateIsAllAutoCalculatedMethod(gc);
        }
        this.generateGetPNameFromMethod(gc);
        this.generateIsNullMethod(gc);
        this.generateIsManagedPNameMethod(gc);
        this.generateNewPNameMethod(gc);
        this.generateCodingSupportedMethod(gc);
        this.generateSupportCompositeFieldMethod(gc);
        this.generateGetNullMethod(gc);
        if (gc.uniqueField != null) {
            this.generateEncodeXXXMethod(gc);
            this.generateDecodeXXXMethod(gc);
        }
        if (!gc.uniqueFieldIsString) {
            this.generateDecodeString(gc);
        }
        this.generateFillStringCoderMethod(gc);
        cv.visitEnd();
        try {
            String fileName = gc.classToWrite;
            fileName = StringReplace.replaceChar((char)'/', (char)File.separatorChar, (String)fileName) + ".class";
            FileOutputStream fos = holder.getFileOutputStream(fileName);
            fos.write(cv.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating PAccessor.");
        }
    }

    private void generateNullFields(BinderGenContext gc) {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            gc.clav.visitField(2, this.getNullFieldName(pe), BinderGenerator.getJVMType(pe.getType()), null, null);
        }
    }

    private void generateACFieldsNAccessors(BinderGenContext gc) {
        String acfJVMType = BinderGenerator.getJVMType(ACF_TYPE);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            if (!pe.isAutoCalculated()) continue;
            String fn = this.getACFName(pe);
            gc.clav.visitField(2, fn, acfJVMType, null, null);
            String upperfl = this.upperFL(pe.getName());
            CodeVisitor cv = gc.clav.visitMethod(1, "getACF" + upperfl, "()" + acfJVMType, null, null);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, gc.classToWrite, fn, acfJVMType);
            cv.visitInsn(176);
            cv.visitMaxs(0, 0);
            cv = gc.clav.visitMethod(1, "setACF" + upperfl, "(" + acfJVMType + ")V", null, null);
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitFieldInsn(181, gc.classToWrite, fn, acfJVMType);
            cv.visitInsn(177);
            cv.visitMaxs(0, 0);
        }
    }

    private void generateIsAllAutoCalculatedMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(4, "isAllAutoCalculated", "()Z", null, null);
        cv.visitInsn(4);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateNoArgConstructor(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, gc.compositeBinderJCN, "<init>", "()V");
        this.generateNullFieldInit(gc, cv);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generatePCMConstructor(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "(" + gc.pcmJT + ")V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(183, gc.compositeBinderJCN, "<init>", "(" + gc.pcmJT + ")V");
        this.generateNullFieldInit(gc, cv);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateGetPNameFromMethod(BinderGenContext gc) throws PException {
        CodeVisitor cv = gc.clav.visitMethod(4, "getPNameFrom", "(" + gc.objectJT + gc.objectJT + gc.objectJT + "Z" + ")" + gc.pnameJT, new String[]{gc.pexceptionJCN}, null);
        int ctxRegisterIndex = 2;
        int connRegisterIndex = 3;
        int computeACFRegisterIndex = 4;
        if (gc.allAutoCalculated) {
            Label labelElsePNGS = new Label();
            cv.visitVarInsn(21, 4);
            cv.visitJumpInsn(153, labelElsePNGS);
            cv.visitTypeInsn(187, gc.xpnameJCN);
            cv.visitInsn(89);
            Iterator it = gc.coAllFields.iterator();
            while (it.hasNext()) {
                PrimitiveElement pe = (PrimitiveElement)it.next();
                this.computeACFValue(gc, cv, 3, pe);
            }
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + gc.xconstructorFieldsPnc + ")V");
            cv.visitInsn(176);
            cv.visitLabel(labelElsePNGS);
        }
        int pngRegisterIndex = 5;
        Label labelElsePNGG = new Label();
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.xpngJCN);
        cv.visitJumpInsn(153, labelElsePNGG);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.xpngJCN);
        cv.visitVarInsn(58, 5);
        cv.visitTypeInsn(187, gc.xpnameJCN);
        cv.visitInsn(89);
        this.fillStackWithPNConstParam(gc, cv, true, 5, 2, 3, 4);
        cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + gc.xconstructorFieldsPnc + ")V");
        cv.visitInsn(176);
        cv.visitLabel(labelElsePNGG);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.pngJCN);
        Label labelElse = new Label();
        cv.visitJumpInsn(153, labelElse);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.pngJCN);
        cv.visitVarInsn(58, 5);
        cv.visitTypeInsn(187, gc.xpnameJCN);
        cv.visitInsn(89);
        this.fillStackWithPNConstParam(gc, cv, false, 5, 2, 3, 4);
        cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + gc.xconstructorFieldsPnc + ")V");
        cv.visitInsn(176);
        cv.visitLabel(labelElse);
        cv.visitInsn(1);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generateIsNullMethod(BinderGenContext gc) throws PException {
        CodeVisitor cv = gc.clav.visitMethod(4, "isNull", "(" + gc.objectJT + gc.objectJT + ")Z", new String[]{gc.pexceptionJCN}, null);
        Label labelFalse = new Label();
        Label labelElsePNG = new Label();
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.xpngJCN);
        cv.visitJumpInsn(153, labelElsePNG);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.xpngJCN);
        cv.visitVarInsn(58, 3);
        this.comparePNGwithNullValue(gc, cv, true, 3, 2, labelFalse);
        cv.visitInsn(4);
        cv.visitInsn(172);
        cv.visitLabel(labelElsePNG);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.pngJCN);
        Label labelElse = new Label();
        cv.visitJumpInsn(153, labelElse);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.pngJCN);
        cv.visitVarInsn(58, 3);
        this.comparePNGwithNullValue(gc, cv, false, 3, 2, labelFalse);
        cv.visitInsn(4);
        cv.visitInsn(172);
        cv.visitLabel(labelElse);
        String exceptionName = BinderGenerator.getJVMClassName(PExceptionNaming.class);
        cv.visitTypeInsn(187, exceptionName);
        cv.visitInsn(89);
        cv.visitTypeInsn(187, gc.stringBufferJCN);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, gc.stringBufferJCN, "<init>", "()V");
        cv.visitLdcInsn("A PNamegetter (generic of specific) is required to decode this object:");
        cv.visitMethodInsn(182, gc.stringBufferJCN, "append", "(" + gc.stringJT + ")" + gc.stringBufferJT);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(182, gc.stringBufferJCN, "append", "(" + gc.objectJT + ")" + gc.stringBufferJT);
        cv.visitMethodInsn(182, gc.stringBufferJCN, "toString", "()" + gc.stringJT);
        cv.visitMethodInsn(183, exceptionName, "<init>", "(" + gc.stringJT + ")V");
        cv.visitInsn(191);
        cv.visitLabel(labelFalse);
        cv.visitInsn(3);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateIsManagedPNameMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(4, "isManagedPName", "(" + gc.objectJT + ")Z", null, null);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.xpnameJCN);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateNewPNameMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(4, "newPName", "(" + gc.pnameJT + ")" + gc.pnameJT, new String[]{gc.pexceptionJCN}, null);
        cv.visitTypeInsn(187, gc.xpnameJCN);
        cv.visitInsn(89);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + gc.pnameManagerJT + gc.pnameJT + ")V");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generateCodingSupportedMethod(BinderGenContext gc) {
        int[] values;
        CodeVisitor cv = gc.clav.visitMethod(1, "codingSupported", "(I)Z", null, null);
        cv.visitVarInsn(21, 1);
        Label labelTrue = new Label();
        Label labelFalse = new Label();
        if (gc.uniqueField == null || gc.uniqueFieldIsString) {
            values = new int[2];
        } else {
            values = new int[3];
            values[2] = CTHelper.ptc2ct((int)gc.uniqueField.getType().getTypeCode());
        }
        values[0] = 1024;
        values[1] = 524288;
        Arrays.sort(values);
        Object[] labels = new Label[values.length];
        Arrays.fill(labels, labelTrue);
        cv.visitLookupSwitchInsn(labelFalse, values, (Label[])labels);
        cv.visitLabel(labelTrue);
        cv.visitInsn(4);
        cv.visitInsn(172);
        cv.visitLabel(labelFalse);
        cv.visitInsn(3);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateSupportCompositeFieldMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "supportCompositeField", "(" + gc.stringJT + gc.ptypeJT + ")Z", null, null);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            Label labelNextTest = new Label();
            cv.visitLdcInsn(pe.getName());
            cv.visitVarInsn(25, 1);
            cv.visitMethodInsn(182, gc.stringJCN, "equals", "(" + gc.objectJT + ")Z");
            cv.visitJumpInsn(154, labelNextTest);
            cv.visitVarInsn(25, 2);
            cv.visitFieldInsn(178, gc.ptypespaceJCN, this.getPTypeSpaceFieldName(pe.getType()), gc.ptypeJT);
            cv.visitMethodInsn(182, gc.ptypeJCN, "isa", "(" + gc.ptypeJT + ")Z");
            cv.visitInsn(172);
            cv.visitLabel(labelNextTest);
        }
        cv.visitInsn(3);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateGetNullMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "getNull", "()" + gc.pnameJT, null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, gc.classToWrite, "nullPName", gc.pnameJT);
        Label l1 = new Label();
        cv.visitJumpInsn(199, l1);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, gc.xpnameJCN, "nullPName", "(" + gc.pnameManagerJT + ")" + gc.pnameJT);
        cv.visitFieldInsn(181, gc.classToWrite, "nullPName", gc.pnameJT);
        cv.visitLabel(l1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, gc.classToWrite, "nullPName", gc.pnameJT);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generateEncodeXXXMethod(BinderGenContext gc) throws PException {
        PType type = gc.uniqueField.getType();
        String jvmFieldType = BinderGenerator.getJVMType(type);
        Type asmType = Type.getType(type.getJavaClass());
        CodeVisitor cv = gc.clav.visitMethod(1, this.getPNameEncodeFunction(type), "(" + gc.pnameJT + ")" + jvmFieldType, new String[]{BinderGenerator.getJVMClassName(PExceptionNaming.class), BinderGenerator.getJVMClassName(UnsupportedOperationException.class)}, null);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.xpnameJCN);
        cv.visitFieldInsn(180, gc.xpnameJCN, gc.uniqueField.getName(), jvmFieldType);
        cv.visitInsn(asmType.getOpcode(172));
        cv.visitMaxs(0, 0);
    }

    private void generateDecodeXXXMethod(BinderGenContext gc) throws PException {
        PType type = gc.uniqueField.getType();
        String jvmFieldType = BinderGenerator.getJVMType(type);
        Type asmType = Type.getType(type.getJavaClass());
        int loadInstr = asmType.getOpcode(21);
        CodeVisitor cv = gc.clav.visitMethod(1, this.getPNameDecodeFunction(type), "(" + jvmFieldType + ")" + gc.pnameJT, new String[]{BinderGenerator.getJVMClassName(PExceptionNaming.class), BinderGenerator.getJVMClassName(UnsupportedOperationException.class)}, null);
        int nullvalRegister = 2;
        boolean isObjectType = this.isObjectType(type);
        if (type.getTypeCode() == 5 || type.getTypeCode() == 7) {
            ++nullvalRegister;
        }
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, gc.classToWrite, "getNull", "()" + gc.pnameJT);
        cv.visitMethodInsn(185, gc.pnameJCN, this.getPNameEncodeFunction(type), "()" + jvmFieldType);
        cv.visitVarInsn(asmType.getOpcode(54), nullvalRegister);
        Label labelNoNulPName = new Label();
        if (isObjectType) {
            Label labelNulPName = new Label();
            Label labelNullCase = new Label();
            cv.visitVarInsn(loadInstr, nullvalRegister);
            cv.visitJumpInsn(198, labelNullCase);
            cv.visitVarInsn(loadInstr, nullvalRegister);
            cv.visitVarInsn(loadInstr, 1);
            cv.visitMethodInsn(182, BinderGenerator.getJVMClassName(type.getJavaClass()), "equals", "(" + BinderGenerator.getJVMType(Object.class) + ")Z");
            cv.visitJumpInsn(154, labelNulPName);
            cv.visitJumpInsn(167, labelNoNulPName);
            cv.visitLabel(labelNullCase);
            cv.visitVarInsn(loadInstr, 1);
            cv.visitJumpInsn(198, labelNulPName);
            cv.visitJumpInsn(167, labelNoNulPName);
            cv.visitLabel(labelNulPName);
        } else {
            cv.visitVarInsn(loadInstr, nullvalRegister);
            cv.visitVarInsn(loadInstr, 1);
            switch (type.getTypeCode()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    cv.visitJumpInsn(160, labelNoNulPName);
                    break;
                }
                case 5: 
                case 7: {
                    cv.visitInsn(148);
                    cv.visitJumpInsn(154, labelNoNulPName);
                }
            }
        }
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, gc.classToWrite, "getNull", "()" + gc.pnameJT);
        cv.visitInsn(176);
        cv.visitLabel(labelNoNulPName);
        cv.visitTypeInsn(187, gc.xpnameJCN);
        cv.visitInsn(89);
        cv.visitVarInsn(loadInstr, 1);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + jvmFieldType + gc.pnameManagerJT + ")V");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generateDecodeString(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "decodeString", "(" + gc.stringJT + ")" + gc.pnameJT, new String[]{BinderGenerator.getJVMClassName(PExceptionNaming.class)}, null);
        Label beginTry = new Label();
        cv.visitLabel(beginTry);
        String bsc = BinderGenerator.getJVMClassName(BasicStringCoder.class);
        cv.visitTypeInsn(187, bsc);
        cv.visitInsn(89);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(183, bsc, "<init>", "(" + gc.stringJT + ")V");
        cv.visitVarInsn(58, 2);
        cv.visitTypeInsn(187, gc.xpnameJCN);
        cv.visitInsn(89);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, gc.xpnameJCN, "<init>", "(" + gc.pnameManagerJT + ")V");
        cv.visitVarInsn(58, 3);
        String pncsc = BinderGenerator.getJVMClassName(PNCStringCoder.class);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            PType type = pe.getType();
            String jvmFieldType = BinderGenerator.getJVMType(type);
            cv.visitVarInsn(25, 3);
            cv.visitVarInsn(25, 2);
            cv.visitMethodInsn(185, pncsc, "get" + this.getCoderName(type), "()" + jvmFieldType);
            cv.visitFieldInsn(181, gc.xpnameJCN, pe.getName(), jvmFieldType);
        }
        Label endTry = new Label();
        cv.visitLabel(endTry);
        Label endCatch = new Label();
        cv.visitJumpInsn(167, endCatch);
        Label beginCatch = new Label();
        cv.visitLabel(beginCatch);
        cv.visitVarInsn(58, 4);
        String pen = BinderGenerator.getJVMClassName(PExceptionNaming.class);
        cv.visitTypeInsn(187, pen);
        cv.visitInsn(89);
        cv.visitVarInsn(25, 4);
        cv.visitLdcInsn("Wrong name structure!!");
        cv.visitMethodInsn(183, pen, "<init>", "(" + BinderGenerator.getJVMType(Exception.class) + gc.stringJT + ")V");
        cv.visitInsn(191);
        cv.visitLabel(endCatch);
        cv.visitVarInsn(25, 3);
        cv.visitInsn(176);
        cv.visitTryCatchBlock(beginTry, endTry, beginCatch, gc.pexceptionJCN);
        cv.visitMaxs(0, 0);
    }

    private void generateFillStringCoderMethod(BinderGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(4, "fillStringCoder", "(" + BinderGenerator.getJVMType(PNCStringCoder.class) + gc.pnameJT + ")V", new String[]{BinderGenerator.getJVMClassName(PExceptionNameCoding.class)}, null);
        if (!gc.uniqueFieldIsString) {
            cv.visitVarInsn(25, 2);
            cv.visitTypeInsn(192, gc.xpnameJCN);
            cv.visitVarInsn(58, 3);
            String pncsc = BinderGenerator.getJVMClassName(PNCStringCoder.class);
            Iterator it = gc.coAllFields.iterator();
            while (it.hasNext()) {
                PrimitiveElement pe = (PrimitiveElement)it.next();
                PType type = pe.getType();
                String jvmFieldType = BinderGenerator.getJVMType(type);
                cv.visitVarInsn(25, 1);
                cv.visitVarInsn(25, 3);
                cv.visitFieldInsn(180, gc.xpnameJCN, pe.getName(), jvmFieldType);
                cv.visitMethodInsn(185, pncsc, "put" + this.getCoderName(type), "(" + jvmFieldType + ")V");
            }
        }
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateNullFieldInit(BinderGenContext gc, CodeVisitor cv) {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            cv.visitVarInsn(25, 0);
            this.loadNullValue(pe, cv);
            cv.visitFieldInsn(181, gc.classToWrite, this.getNullFieldName(pe), BinderGenerator.getJVMType(pe.getType()));
        }
    }

    private void fillStackWithPNConstParam(BinderGenContext gc, CodeVisitor cv, boolean specificPNG, int pngRegisterIndex, int ctxRegisterIndex, int connRegisterIndex, int computeACFRegisterIndex) throws PException {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            if (pe.isAutoCalculated()) {
                Label labelElse = new Label();
                Label labelEnd = new Label();
                cv.visitVarInsn(21, computeACFRegisterIndex);
                cv.visitJumpInsn(153, labelElse);
                this.computeACFValue(gc, cv, connRegisterIndex, pe);
                cv.visitJumpInsn(167, labelEnd);
                cv.visitLabel(labelElse);
                this.loadValuesFromPNG(gc, cv, specificPNG, pngRegisterIndex, ctxRegisterIndex, connRegisterIndex, pe);
                cv.visitLabel(labelEnd);
                continue;
            }
            this.loadValuesFromPNG(gc, cv, specificPNG, pngRegisterIndex, ctxRegisterIndex, connRegisterIndex, pe);
        }
        cv.visitVarInsn(25, 0);
    }

    private void computeACFValue(BinderGenContext gc, CodeVisitor cv, int connRegisterIndex, PrimitiveElement pe) throws PException {
        int tc = pe.getType().getTypeCode();
        String classToInstanciate = null;
        switch (tc) {
            case 12: 
            case 13: {
                classToInstanciate = BinderGenerator.getJVMClassName(pe.getType().getJavaClass());
                cv.visitTypeInsn(187, classToInstanciate);
                cv.visitInsn(89);
            }
        }
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, gc.classToWrite, this.getACFName(pe), BinderGenerator.getJVMType(ACF_TYPE));
        cv.visitVarInsn(25, connRegisterIndex);
        cv.visitMethodInsn(185, BinderGenerator.getJVMClassName(ACF_TYPE), "genId", "(" + gc.objectJT + ")J");
        switch (tc) {
            case 4: {
                cv.visitInsn(136);
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                cv.visitInsn(136);
                cv.visitMethodInsn(183, classToInstanciate, "<init>", "(I)V");
                break;
            }
            case 13: {
                cv.visitMethodInsn(183, classToInstanciate, "<init>", "(J)V");
                break;
            }
            default: {
                throw new PException("Auto calculated field not supported for the field type: " + pe.getType().getJavaName());
            }
        }
    }

    private void loadValuesFromPNG(BinderGenContext gc, CodeVisitor cv, boolean specificPNG, int pngRegisterIndex, int ctxRegisterIndex, int connRegisterIndex, PrimitiveElement pe) throws PException {
        String jvmFieldType = BinderGenerator.getJVMType(pe.getType());
        if (specificPNG) {
            cv.visitVarInsn(25, pngRegisterIndex);
            cv.visitVarInsn(25, ctxRegisterIndex);
            cv.visitMethodInsn(185, gc.xpngJCN, "pnGet" + this.upperFL(pe.getName()), "(" + gc.objectJT + ")" + jvmFieldType);
        } else {
            cv.visitVarInsn(25, pngRegisterIndex);
            cv.visitLdcInsn(pe.getName());
            cv.visitVarInsn(25, ctxRegisterIndex);
            cv.visitMethodInsn(185, gc.pngJCN, this.getPNameGetterGetFunction(pe.getType()), "(" + gc.stringJT + gc.objectJT + ")" + jvmFieldType);
        }
    }

    private void comparePNGwithNullValue(BinderGenContext gc, CodeVisitor cv, boolean specificPNG, int pngRegisterIndex, int ctxRegisterIndex, Label labelFalse) throws PException {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            String fn = this.getNullFieldName(pe);
            String jvmFieldType = BinderGenerator.getJVMType(pe.getType());
            Label labelNextTest = new Label();
            if (this.isObjectType(pe.getType())) {
                Label labelNullCase = new Label();
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, gc.classToWrite, fn, jvmFieldType);
                cv.visitJumpInsn(198, labelNullCase);
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, gc.classToWrite, fn, jvmFieldType);
                this.loadValueFromPNG(gc, pe, cv, specificPNG, pngRegisterIndex, ctxRegisterIndex);
                cv.visitMethodInsn(182, BinderGenerator.getJVMClassName(pe.getType().getJavaClass()), "equals", "(" + BinderGenerator.getJVMType(class$java$lang$Object == null ? BinderGenerator.class$("java.lang.Object") : class$java$lang$Object) + ")Z");
                cv.visitJumpInsn(153, labelFalse);
                cv.visitJumpInsn(167, labelNextTest);
                cv.visitLabel(labelNullCase);
                this.loadValueFromPNG(gc, pe, cv, specificPNG, pngRegisterIndex, ctxRegisterIndex);
                cv.visitJumpInsn(199, labelFalse);
            } else {
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, gc.classToWrite, fn, jvmFieldType);
                this.loadValueFromPNG(gc, pe, cv, specificPNG, pngRegisterIndex, ctxRegisterIndex);
                switch (pe.getType().getTypeCode()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        cv.visitJumpInsn(160, labelFalse);
                        break;
                    }
                    case 5: 
                    case 7: {
                        cv.visitInsn(148);
                        cv.visitJumpInsn(154, labelFalse);
                    }
                }
            }
            cv.visitLabel(labelNextTest);
        }
    }

    private void loadValueFromPNG(BinderGenContext gc, PrimitiveElement pe, CodeVisitor cv, boolean specificPNG, int pngRegisterIndex, int ctxRegisterIndex) throws PException {
        String jvmFieldType = BinderGenerator.getJVMType(pe.getType());
        if (specificPNG) {
            cv.visitVarInsn(25, pngRegisterIndex);
            cv.visitVarInsn(25, ctxRegisterIndex);
            cv.visitMethodInsn(185, gc.xpngJCN, "pnGet" + this.upperFL(pe.getName()), "(" + gc.objectJT + ")" + jvmFieldType);
        } else {
            cv.visitVarInsn(25, pngRegisterIndex);
            cv.visitLdcInsn(pe.getName());
            cv.visitVarInsn(25, ctxRegisterIndex);
            cv.visitMethodInsn(185, gc.pngJCN, this.getPNameGetterGetFunction(pe.getType()), "(" + gc.stringJT + gc.objectJT + ")" + jvmFieldType);
        }
    }

    private String getACFName(PrimitiveElement pe) {
        return pe.getName() + "JormLongGen";
    }

    private String getNullFieldName(PrimitiveElement pe) {
        return "jorm" + pe.getName();
    }

    private void loadNullValue(PrimitiveElement pe, CodeVisitor cv) {
        BinderGenerator.loadNull(cv, pe.getType());
    }

    private static final class BinderGenContext
    extends CNGenContext {
        public final String compositeBinderJCN;
        public final String classToWrite;

        public BinderGenContext(CompositeName _co, ClassVisitor _clav, CommonJVMHelper h) {
            super(_co, _clav, h);
            this.classToWrite = this.xbinderJCN;
            this.compositeBinderJCN = CommonJVMHelper.getJVMClassName(class$org$objectweb$jorm$naming$lib$CompositePBinder == null ? (class$org$objectweb$jorm$naming$lib$CompositePBinder = BinderGenerator.class$("org.objectweb.jorm.naming.lib.CompositePBinder")) : class$org$objectweb$jorm$naming$lib$CompositePBinder);
        }
    }
}

