/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.message.Message;

public class Servlet3ContinuationProvider
implements ContinuationProvider {
    HttpServletRequest req;
    HttpServletResponse resp;
    Message inMessage;

    public Servlet3ContinuationProvider(HttpServletRequest req, HttpServletResponse resp, Message inMessage) {
        this.inMessage = inMessage;
        this.req = req;
        this.resp = resp;
    }

    public Continuation getContinuation() {
        if (this.inMessage.getExchange().isOneWay()) {
            return null;
        }
        return new Servlet3Continuation();
    }

    public class Servlet3Continuation
    implements Continuation,
    AsyncListener {
        AsyncContext context;
        boolean isNew;
        boolean isResumed;
        boolean isPending;
        Object obj;

        public Servlet3Continuation() {
            boolean bl = this.isNew = !Servlet3ContinuationProvider.this.req.isAsyncStarted();
            if (this.isNew) {
                Servlet3ContinuationProvider.this.req.setAttribute("cxf.continuation.message", (Object)Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage());
                this.context = Servlet3ContinuationProvider.this.req.startAsync((ServletRequest)Servlet3ContinuationProvider.this.req, (ServletResponse)Servlet3ContinuationProvider.this.resp);
                this.context.addListener((AsyncListener)this);
            } else {
                this.context = Servlet3ContinuationProvider.this.req.getAsyncContext();
            }
        }

        public boolean suspend(long timeout) {
            if (this.isPending) {
                return false;
            }
            this.context.setTimeout(timeout);
            this.isNew = false;
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().getInterceptorChain().suspend();
            this.isPending = true;
            return true;
        }

        public void redispatch() {
            this.context.dispatch();
        }

        public void resume() {
            this.isResumed = true;
            this.redispatch();
        }

        public void reset() {
            this.context.complete();
            this.obj = null;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isPending() {
            return this.isPending;
        }

        public boolean isResumed() {
            return this.isResumed;
        }

        public Object getObject() {
            return this.obj;
        }

        public void setObject(Object o) {
            this.obj = o;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            Servlet3ContinuationProvider.this.inMessage.getExchange().getInMessage().remove("cxf.continuation.message");
            this.isPending = false;
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.isPending = false;
            this.redispatch();
        }
    }
}

