/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.clue.basiccluemanager;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.api.clue.basiccluemanager.IClueAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClueManager<E, C>
implements IClueManager<E, C> {
    private List<C> busyClue;
    private boolean clueResetable;
    private IClueAccessor<E, C> clueAccessor;

    public BasicClueManager(IClueAccessor<E, C> clueAccessor) {
        this(clueAccessor, true, true);
    }

    public BasicClueManager(IClueAccessor<E, C> clueAccessor, boolean clueShareable, boolean clueResetable) {
        this.clueAccessor = clueAccessor;
        this.clueResetable = clueResetable;
        if (!clueShareable) {
            this.busyClue = new ArrayList<C>();
        }
    }

    @Override
    public boolean tryMatch(E item, C clue) {
        if (clue == null) {
            if (this.clueAccessor.getClue(item) == null) {
                return true;
            }
            if (this.clueResetable) {
                this.clueAccessor.setClue(item, null);
                return true;
            }
            return false;
        }
        if (this.busyClue != null && this.busyClue.contains(clue)) {
            return false;
        }
        C itemClue = this.clueAccessor.getClue(item);
        if (itemClue == null) {
            this.clueAccessor.setClue(item, clue);
            if (this.busyClue != null) {
                this.busyClue.add(clue);
            }
            return true;
        }
        if (itemClue.equals(clue)) {
            if (this.busyClue != null) {
                this.busyClue.add(clue);
            }
            return true;
        }
        if (this.clueResetable) {
            this.clueAccessor.setClue(item, clue);
            if (this.busyClue != null) {
                this.busyClue.add(clue);
            }
            return true;
        }
        return false;
    }

    @Override
    public void unMatch(E item) {
        if (this.busyClue != null) {
            this.busyClue.remove(this.clueAccessor.getClue(item));
        }
    }
}

