/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.keepbusy;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.api.keepbusy.ShareMethod;
import org.ow2.util.pool.impl.enhanced.impl.PoolError;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IIdentityReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IdentityReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.IdentityWeakReference;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.PoolItemInfo;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.PoolStackTrace;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.ReferenceType;
import org.ow2.util.pool.impl.enhanced.impl.util.LockFactory;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.NoWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepBusyPool<E>
implements IPool<E> {
    private static final Log LOG = LogFactory.getLog(KeepBusyPool.class);
    private Map<IIdentityReference<E>, PoolItemInfo> busyPoolItemList;
    private ReferenceQueue<E> referenceQueue;
    private ShareMethod shareMethod;
    private Lock lock;
    private IPool<E> pool;
    private ReferenceType referenceType;
    private WaitAuthorization currentWaitAuthorization;

    public KeepBusyPool(IPool<E> pool) {
        this(pool, ReferenceType.WEAK);
    }

    public KeepBusyPool(IPool<E> pool, ReferenceType referenceType) {
        if (pool == null) {
            throw new IllegalArgumentException();
        }
        this.lock = LockFactory.createLock();
        this.referenceType = referenceType;
        this.pool = pool;
        this.busyPoolItemList = new HashMap<IIdentityReference<E>, PoolItemInfo>();
        this.shareMethod = ShareMethod.NEVER_SHARE;
        switch (referenceType) {
            case STRONG: {
                break;
            }
            default: {
                this.referenceQueue = new ReferenceQueue();
            }
        }
        this.currentWaitAuthorization = new WaitAuthorization();
    }

    protected void expunge() {
        switch (this.referenceType) {
            case STRONG: {
                return;
            }
        }
        Reference<E> reference = this.referenceQueue.poll();
        while (reference != null) {
            PoolItemInfo poolItemInfo = this.busyPoolItemList.remove(reference);
            int busyCount = poolItemInfo.getBusyCount();
            if (busyCount != 0 && LOG.isWarnEnabled()) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                for (Throwable throwable : poolItemInfo.getThrowableList()) {
                    throwable.printStackTrace(printWriter);
                    printWriter.append("\n");
                }
                if (busyCount == 1) {
                    LOG.warn((Object)"A poolItem was GC while user didn''t send back their instance to pool.\nStackTrace :\n{0}", new Object[]{charArrayWriter});
                } else {
                    LOG.warn((Object)"A poolItem was GC while {0} users didn''t send back their instance to pool.\nStackTraces :\n{1}", new Object[]{busyCount, charArrayWriter});
                }
            }
            reference = this.referenceQueue.poll();
        }
    }

    private E lookForAvailableInstance() throws PoolException, InterruptedException {
        try {
            E poolItem = this.pool.get(NoWaitControl.INSTANCE);
            if (this.shareMethod != ShareMethod.NEVER_SHARE) {
                this.currentWaitAuthorization.forbidWait();
                this.currentWaitAuthorization = new WaitAuthorization();
                this.pool.signalAllWaiters();
            }
            LOG.debug((Object)"pool returns NEW {0}", new Object[]{poolItem});
            return poolItem;
        }
        catch (TimeoutPoolException e) {
            return null;
        }
    }

    private E lookForSharedInstance() {
        Iterator<IIdentityReference<E>> iterator = this.busyPoolItemList.keySet().iterator();
        E poolItem = null;
        while (poolItem == null && iterator.hasNext()) {
            poolItem = iterator.next().getReference();
        }
        LOG.debug((Object)"pool returns SHARED {0}", new Object[]{poolItem});
        return poolItem;
    }

    private E lookForInstance() throws PoolException, InterruptedException {
        E poolItem;
        switch (this.shareMethod) {
            default: {
                poolItem = this.lookForAvailableInstance();
                break;
            }
            case SHARE_AS_LAST_SOLUTION: {
                poolItem = this.lookForAvailableInstance();
                if (poolItem != null) break;
                poolItem = this.lookForSharedInstance();
                break;
            }
            case SHARE_IF_POSSIBLE: {
                poolItem = this.lookForSharedInstance();
                if (poolItem != null) break;
                poolItem = this.lookForAvailableInstance();
            }
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        E poolItem = null;
        this.lock.lock();
        try {
            IdentityReference<Object> strongReference;
            PoolItemInfo poolItemInfo;
            this.expunge();
            poolItem = this.lookForInstance();
            if (poolItem == null) {
                boolean stopWaiting = false;
                if (!timeout.canContinueToWait()) {
                    throw new TimeoutPoolException();
                }
                while (!stopWaiting) {
                    block21: {
                        try {
                            timeout.pushWaitAuthorization(this.currentWaitAuthorization);
                            this.lock.unlock();
                            try {
                                poolItem = this.pool.get(timeout);
                            }
                            finally {
                                this.lock.lock();
                                timeout.popWaitAuthorization();
                            }
                            if (this.shareMethod != ShareMethod.NEVER_SHARE) {
                                this.currentWaitAuthorization.forbidWait();
                                this.currentWaitAuthorization = new WaitAuthorization();
                                this.pool.signalAllWaiters();
                            }
                        }
                        catch (WaiterInterruptedException e) {
                            timeout.verifyInterrupted();
                            if (this.shareMethod != ShareMethod.NEVER_SHARE) {
                                poolItem = this.lookForSharedInstance();
                            }
                        }
                        catch (TimeoutPoolException e) {
                            if (this.shareMethod == ShareMethod.NEVER_SHARE) break block21;
                            poolItem = this.lookForSharedInstance();
                        }
                    }
                    if (poolItem != null) {
                        stopWaiting = true;
                        continue;
                    }
                    if (timeout.canContinueToWait()) continue;
                    throw new TimeoutPoolException();
                }
            }
            if ((poolItemInfo = this.busyPoolItemList.get(strongReference = new IdentityReference<Object>(poolItem))) == null) {
                IIdentityReference<Object> toPutIdentityReference;
                poolItemInfo = new PoolItemInfo();
                switch (this.getReferenceType()) {
                    case STRONG: {
                        toPutIdentityReference = strongReference;
                        break;
                    }
                    default: {
                        toPutIdentityReference = new IdentityWeakReference<Object>(poolItem, (ReferenceQueue<Object>)this.referenceQueue);
                    }
                }
                this.busyPoolItemList.put(toPutIdentityReference, poolItemInfo);
            } else {
                poolItemInfo.setBusyCount(poolItemInfo.getBusyCount() + 1);
            }
            poolItemInfo.addStackTraceElements(new PoolStackTrace());
        }
        finally {
            this.lock.unlock();
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E poolItem) throws NotABusyPoolItemException {
        if (poolItem == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            this.expunge();
            PoolItemInfo poolItemInfo = this.busyPoolItemList.get(new IdentityReference<E>(poolItem));
            if (poolItemInfo == null) {
                throw new NotABusyPoolItemException();
            }
            int sharedCountValue = poolItemInfo.getBusyCount();
            if (sharedCountValue == 1) {
                this.busyPoolItemList.remove(new IdentityReference<E>(poolItem));
                if (!poolItemInfo.isRemoved()) {
                    this.lock.unlock();
                    try {
                        this.pool.put(poolItem);
                    }
                    finally {
                        this.lock.lock();
                    }
                }
                poolItemInfo.setBusyCount(0);
            } else {
                poolItemInfo.setBusyCount(sharedCountValue - 1);
            }
            if (this.shareMethod != ShareMethod.NEVER_SHARE) {
                this.currentWaitAuthorization.forbidWait();
                this.currentWaitAuthorization = new WaitAuthorization();
                this.pool.signalAllWaiters();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ShareMethod getShareMethod0() {
        return this.shareMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareMethod getShareMethod() {
        this.lock.lock();
        try {
            ShareMethod shareMethod = this.shareMethod;
            return shareMethod;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShareMethod(ShareMethod shareMethod) {
        this.lock.lock();
        try {
            this.shareMethod = shareMethod;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWaiters() {
        this.lock.lock();
        try {
            this.currentWaitAuthorization.forbidWait();
            this.currentWaitAuthorization = new WaitAuthorization();
            this.pool.signalAllWaiters();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(E poolItem) throws NotABusyPoolItemException {
        if (poolItem == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int sharedCountValue;
            this.expunge();
            PoolItemInfo poolItemInfo = this.busyPoolItemList.get(new IdentityReference<E>(poolItem));
            if (poolItemInfo == null) {
                throw new NotABusyPoolItemException();
            }
            if (!poolItemInfo.isRemoved()) {
                this.lock.unlock();
                try {
                    this.pool.remove(poolItem);
                }
                finally {
                    this.lock.lock();
                }
                poolItemInfo.setRemoved(true);
            }
            if ((sharedCountValue = poolItemInfo.getBusyCount()) == 1) {
                this.busyPoolItemList.remove(new IdentityReference<E>(poolItem));
                poolItemInfo.setBusyCount(0);
            } else {
                poolItemInfo.setBusyCount(sharedCountValue - 1);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<IIdentityReference<E>, PoolItemInfo> getBusyPoolItemList() {
        return this.busyPoolItemList;
    }

    protected final Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.lock.lock();
        try {
            this.expunge();
            for (Map.Entry<IIdentityReference<E>, PoolItemInfo> entry : this.busyPoolItemList.entrySet()) {
                PoolItemInfo poolItemInfo = entry.getValue();
                E poolItem = entry.getKey().getReference();
                if (poolItem == null || poolItemInfo.isRemoved()) continue;
                this.lock.unlock();
                try {
                    this.pool.remove(poolItem);
                }
                catch (NotABusyPoolItemException e) {
                    throw new PoolError();
                }
                finally {
                    this.lock.lock();
                }
                poolItemInfo.setRemoved(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ReferenceQueue<E> getReferenceQueue() {
        return this.referenceQueue;
    }

    protected ReferenceType getReferenceType() {
        return this.referenceType;
    }

    protected WaitAuthorization getCurrentWaitAuthorization() {
        return this.currentWaitAuthorization;
    }

    protected void setCurrentWaitAuthorization(WaitAuthorization currentWaitAuthorization) {
        this.currentWaitAuthorization = currentWaitAuthorization;
    }
}

