/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty8;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.jasper.JasperException;
import org.apache.jasper.runtime.TldScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASTldScanner
extends TldScanner {
    private TldScanner delegateTldScanner = null;
    private boolean initialized = false;
    private List<URL> resourcesToMonitor = null;

    public JOnASTldScanner(TldScanner delegateTldScanner, List<URL> resourcesToMonitor) {
        this.delegateTldScanner = delegateTldScanner;
        this.resourcesToMonitor = resourcesToMonitor;
    }

    @Override
    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            HashMap mappings;
            Method scanTldMethod;
            this.delegateTldScanner.getLocation(uri);
            try {
                scanTldMethod = TldScanner.class.getDeclaredMethod("scanTld", String.class, String.class, InputStream.class);
            }
            catch (SecurityException e) {
                throw new JasperException("Unable to get scanTld method", e);
            }
            catch (NoSuchMethodException e) {
                throw new JasperException("Unable to get scanTld method", e);
            }
            scanTldMethod.setAccessible(true);
            Field mappingsField = null;
            try {
                mappingsField = TldScanner.class.getDeclaredField("mappings");
            }
            catch (SecurityException e) {
                throw new JasperException("Unable to get mappings field", e);
            }
            catch (NoSuchFieldException e) {
                throw new JasperException("Unable to get mappings field", e);
            }
            mappingsField.setAccessible(true);
            try {
                mappings = (HashMap)mappingsField.get(this.delegateTldScanner);
            }
            catch (IllegalArgumentException e) {
                throw new JasperException("Unable to get mappings field", e);
            }
            catch (IllegalAccessException e) {
                throw new JasperException("Unable to get mappings field", e);
            }
            if (this.resourcesToMonitor != null) {
                for (URL url : this.resourcesToMonitor) {
                    Object tldInfo = null;
                    try {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setDefaultUseCaches(false);
                        tldInfo = scanTldMethod.invoke((Object)this.delegateTldScanner, url.toString(), null, urlConnection.getInputStream());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    if (tldInfo == null) continue;
                    Field uriField = null;
                    try {
                        uriField = tldInfo.getClass().getDeclaredField("uri");
                    }
                    catch (SecurityException e) {
                        throw new JasperException("Unable to get uri field", e);
                    }
                    catch (NoSuchFieldException e) {
                        throw new JasperException("Unable to get uri field", e);
                    }
                    uriField.setAccessible(true);
                    String uriStr = null;
                    try {
                        uriStr = (String)uriField.get(tldInfo);
                    }
                    catch (IllegalArgumentException e) {
                        throw new JasperException("Unable to get listeners field", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new JasperException("Unable to get listeners field", e);
                    }
                    mappings.put(uriStr, new String[]{url.toString(), null});
                }
            }
            this.initialized = true;
        }
        return this.delegateTldScanner.getLocation(uri);
    }

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext ctxt) throws ServletException {
        this.delegateTldScanner.onStartup(c, ctxt);
    }
}

