/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;

public class JarResource
extends URLResource {
    protected JarURLConnection _jarConnection;

    JarResource(URL url) {
        super(url, null);
    }

    JarResource(URL url, boolean useCaches) {
        super(url, null, useCaches);
    }

    @Override
    public synchronized void release() {
        this._jarConnection = null;
        super.release();
    }

    @Override
    protected synchronized boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException e) {
            Log.ignore(e);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() throws IOException {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    @Override
    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return new FilterInputStream(super.getInputStream()){

                @Override
                public void close() throws IOException {
                    this.in = IO.getClosedStream();
                }
            };
        }
        URL url = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream is = url.openStream();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(File directory) throws IOException {
        Manifest manifest;
        JarEntry entry;
        boolean subEntryIsDir;
        String urlString;
        int endOfJarUrl;
        int startOfJarUrl;
        if (Log.isDebugEnabled()) {
            Log.debug("Extract " + this + " to " + directory);
        }
        int n = startOfJarUrl = (endOfJarUrl = (urlString = this.getURL().toExternalForm().trim()).indexOf("!/")) >= 0 ? 4 : 0;
        if (endOfJarUrl < 0) {
            throw new IOException("Not a valid jar url: " + urlString);
        }
        URL jarFileURL = new URL(urlString.substring(startOfJarUrl, endOfJarUrl));
        String subEntryName = endOfJarUrl + 2 < urlString.length() ? urlString.substring(endOfJarUrl + 2) : null;
        boolean bl = subEntryIsDir = subEntryName != null && subEntryName.endsWith("/");
        if (Log.isDebugEnabled()) {
            Log.debug("Extracting entry = " + subEntryName + " from jar " + jarFileURL);
        }
        InputStream is = jarFileURL.openConnection().getInputStream();
        JarInputStream jin = new JarInputStream(is);
        String directoryCanonicalPath = directory.getCanonicalPath() + "/";
        while ((entry = jin.getNextJarEntry()) != null) {
            String entryName = entry.getName();
            boolean shouldExtract = subEntryName != null && entryName.startsWith(subEntryName) ? (subEntryIsDir ? !(entryName = entryName.substring(subEntryName.length())).equals("") : true) : subEntryName == null || entryName.startsWith(subEntryName);
            if (!shouldExtract) {
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Skipping entry: " + entryName);
                continue;
            }
            String dotCheck = entryName.replace('\\', '/');
            if ((dotCheck = URIUtil.canonicalPath(dotCheck)) == null) {
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Invalid entry: " + entryName);
                continue;
            }
            File file = new File(directory, entryName);
            if (entry.isDirectory()) {
                if (file.exists()) continue;
                file.mkdirs();
                continue;
            }
            File dir = new File(file.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                IO.copy(jin, fout);
            }
            catch (Throwable throwable) {
                IO.close(fout);
                throw throwable;
            }
            IO.close(fout);
            if (entry.getTime() < 0L) continue;
            file.setLastModified(entry.getTime());
        }
        if ((subEntryName == null || subEntryName != null && subEntryName.equalsIgnoreCase("META-INF/MANIFEST.MF")) && (manifest = jin.getManifest()) != null) {
            File metaInf = new File(directory, "META-INF");
            metaInf.mkdir();
            File f = new File(metaInf, "MANIFEST.MF");
            FileOutputStream fout = new FileOutputStream(f);
            manifest.write(fout);
            fout.close();
        }
        IO.close(jin);
    }

    public static Resource newJarResource(Resource resource) throws IOException {
        if (resource instanceof JarResource) {
            return resource;
        }
        return Resource.newResource("jar:" + resource + "!/");
    }
}

