/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.MessageOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ByteArrayMessageOutputStream
extends MessageOutputStream {
    public ByteArrayMessageOutputStream() throws IOException {
        this(8192);
    }

    public ByteArrayMessageOutputStream(int size) throws IOException {
        super(size);
    }

    public final void write(int b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            newcount = Math.max(this.buf.length << 1, newcount);
            byte[] newbuf = new byte[newcount];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count++] = (byte)b;
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            newcount = Math.max(this.buf.length << 1, newcount);
            byte[] newbuf = new byte[newcount];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public final int size() {
        return this.count;
    }

    public final void reset() {
        this.count = 0;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

