/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.DistributionHandler;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionModule
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)DistributionModule.class.getName());
    public static final String CLASS_NAME = "distribution.className";
    public static final String KEEP_MESSAGE_OPTION = "distribution.keep";
    private boolean keep = false;
    private DistributionHandler distributionHandler;
    private final Destination destination;

    public DistributionModule(Destination destination, Properties properties) {
        this.destination = destination;
        this.setProperties(properties);
    }

    private void setProperties(Properties props) {
        if (props == null) {
            return;
        }
        this.keep = false;
        if (props.containsKey(KEEP_MESSAGE_OPTION)) {
            try {
                this.keep = ConversionHelper.toBoolean((Object)props.get(KEEP_MESSAGE_OPTION));
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't parse keep message option.", (Throwable)exc);
            }
            props.remove(KEEP_MESSAGE_OPTION);
        }
        if (props.containsKey(CLASS_NAME)) {
            try {
                String className = ConversionHelper.toString((Object)props.get(CLASS_NAME));
                props.remove(CLASS_NAME);
                Class<?> clazz = Class.forName(className);
                this.distributionHandler = (DistributionHandler)clazz.newInstance();
                this.distributionHandler.init(props);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't create distribution handler.", (Throwable)exc);
            }
        }
    }

    public ClientMessages processMessages(ClientMessages cm) {
        List msgs = cm.getMessages();
        DMQManager dmqManager = null;
        for (int i = 0; i < msgs.size(); ++i) {
            Message msg = (Message)msgs.get(i);
            try {
                this.distributionHandler.distribute(msg);
                continue;
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"DistributionModule: distribution error.", (Throwable)exc);
                if (dmqManager == null) {
                    dmqManager = new DMQManager(cm.getDMQId(), this.destination.getDMQAgentId(), this.destination.getId());
                }
                dmqManager.addDeadMessage(msg, (short)2);
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (this.keep) {
            return cm;
        }
        return null;
    }

    public void updateProperties(Properties properties) throws Exception {
        this.setProperties(properties);
    }

    public void close() {
        this.distributionHandler.close();
    }
}

