/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.deployer.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.datasource.binding.DatasourceType;
import org.ow2.jonas.datasource.binding.Datasources;
import org.ow2.jonas.datasource.deploy.deployable.api.DatasourceDeployable;
import org.ow2.jonas.datasource.deployer.api.IDatasourceDeployer;
import org.ow2.jonas.datasource.reader.DatasourceXmlReader;
import org.ow2.jonas.generators.raconfig.RAConfig;
import org.ow2.jonas.generators.raconfig.RAConfigException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceDeployer
implements IDatasourceDeployer {
    private Log logger = LogFactory.getLog(DatasourceDeployer.class);
    private IDeployerManager deployerManager = null;
    private DatasourceXmlReader datasourceReader;
    private static final String DEFAULT_ARCHIVE_PATH = "deployer" + File.separator + "datasources";
    protected File archiveFile = null;
    private Map<DatasourceDeployable, String> datasourceDeployables = new HashMap<DatasourceDeployable, String>();
    protected ServerProperties serverProps;
    protected DeployerLog deployerLog = null;
    private String dmRar;

    protected void undeployDatasource(DatasourceDeployable datasourceDeployable) throws DeployerException {
        this.logger.info((Object)"Undeploying {0}", new Object[]{datasourceDeployable});
        File rarFile = new File(this.getRarFilePathForDeployable(datasourceDeployable));
        IArchive archiveRar = ArchiveManager.getInstance().getArchive((Object)rarFile);
        if (archiveRar == null) {
            throw new DeployerException("Null archive for file " + rarFile);
        }
        IDeployable rardeployable = null;
        try {
            rardeployable = DeployableHelper.getDeployable((IArchive)archiveRar);
        }
        catch (DeployableHelperException e) {
            throw new DeployerException((Throwable)e);
        }
        if (rardeployable == null) {
            throw new DeployerException("Null deployable for archive " + archiveRar);
        }
        try {
            this.deployerManager.undeploy(rardeployable);
        }
        catch (DeployerException e) {
            throw new DeployerException("Exception while undeploying deployable " + rardeployable, (Throwable)e);
        }
        catch (UnsupportedDeployerException e) {
            throw new DeployerException("No deployer found for deployable " + rardeployable, (Throwable)e);
        }
        this.datasourceDeployables.remove(datasourceDeployable);
    }

    protected void deployDatasource(IDeployable<?> deployable) throws DeployerException {
        this.logger.debug((Object)"Request to deploy {0} received", new Object[]{deployable});
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!DatasourceDeployable.class.isAssignableFrom(deployable.getClass())) {
            throw new DeployerException("Bad deployable type " + deployable.getClass());
        }
        this.logger.info((Object)"Deploying datasource {0}", new Object[]{deployable});
        DatasourceDeployable datasourceDeployable = (DatasourceDeployable)DatasourceDeployable.class.cast(deployable);
        this.datasourceReader = new DatasourceXmlReader();
        if (this.datasourceReader == null) {
            throw new DeployerException("Deployment aborted - The DatasourceReader is null");
        }
        File xmlfile = this.getFile(datasourceDeployable);
        Datasources datasources = null;
        try {
            datasources = this.datasourceReader.extractDataSources(xmlfile);
        }
        catch (Exception e) {
            throw new DeployerException("Error while parsing file " + xmlfile + " - Deployment aborted", (Throwable)e);
        }
        if (datasources == null) {
            throw new DeployerException("The deployable " + deployable + " resolved in null datasource - Deployment aborted");
        }
        datasourceDeployable.setAttachedData(datasources);
        for (DatasourceType ds : datasources.getDatasources()) {
            DatasourceType dsInitialized = this.datasourceReader.initDataSource(ds);
            Properties properties = this.datasourceReader.getProperties(dsInitialized);
            String fileIn = null;
            String fileOut = null;
            String fileName = "";
            try {
                fileName = "ds-" + dsInitialized.getDatasourceConfiguration().getName().replace('/', '_') + "-";
                fileOut = File.createTempFile(fileName, ".rar", this.archiveFile).getAbsolutePath();
            }
            catch (IOException e1) {
                String msg = "Error while creating temp file <" + fileName + ".rar> in directory <" + this.archiveFile.getPath() + ">";
                throw new DeployerException(msg, (Throwable)e1);
            }
            fileIn = this.dmRar;
            this.logger.info((Object)"Generate RAR {0} -> {1}", new Object[]{fileIn, fileOut});
            try {
                RAConfig.generateRars((Properties)properties, (String)"JOnASJDBC_DM", (String)fileIn, (String)fileOut);
            }
            catch (RAConfigException e) {
                this.logger.error((Object)"Failure to deploy datasource {0}", new Object[]{ds});
                throw new DeployerException((Throwable)e);
            }
            File generatedFile = new File(fileOut);
            if (!generatedFile.exists()) {
                this.logger.error((Object)"RAR was not generated with RAConfig- {0}", new Object[]{fileOut});
                throw new DeployerException("RAR was not generated <" + fileOut + ">");
            }
            IArchive archiveRar = ArchiveManager.getInstance().getArchive((Object)generatedFile);
            if (archiveRar == null) {
                throw new DeployerException("Null archive for file " + fileOut);
            }
            IDeployable rardeployable = null;
            try {
                rardeployable = DeployableHelper.getDeployable((IArchive)archiveRar);
            }
            catch (DeployableHelperException e) {
                throw new DeployerException((Throwable)e);
            }
            if (rardeployable == null) {
                throw new DeployerException("Null deployable for archive " + archiveRar);
            }
            try {
                this.deployerManager.deploy(rardeployable);
            }
            catch (DeployerException e) {
                throw new DeployerException("Exception while deploying deployable " + rardeployable, (Throwable)e);
            }
            catch (UnsupportedDeployerException e) {
                throw new DeployerException("No deployer found for deployable " + rardeployable, (Throwable)e);
            }
            this.datasourceDeployables.put(datasourceDeployable, fileOut);
            try {
                if (this.deployerLog == null) continue;
                File unpackedFile = URLUtils.urlToFile((URL)datasourceDeployable.getArchive().getURL());
                this.deployerLog.addEntry(xmlfile, new File(fileOut));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get  the url of the initial deployable for the datasource Module '" + deployable + "'.", (Throwable)e);
            }
        }
    }

    protected File getFile(DatasourceDeployable datasourceDeployable) throws DeployerException {
        URL datasourceURL = null;
        try {
            datasourceURL = datasourceDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from Datasource deployable '" + datasourceDeployable + "'.", (Throwable)e);
        }
        return URLUtils.urlToFile((URL)datasourceURL);
    }

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (DatasourceDeployable.class.isAssignableFrom(deployable.getClass())) {
            this.deployDatasource(deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        if (this.supports(deployable)) {
            return this.datasourceDeployables.get(deployable) != null;
        }
        return false;
    }

    public boolean isDeployed(String rarFileName) {
        return this.datasourceDeployables.containsValue(rarFileName);
    }

    public boolean supports(IDeployable<?> deployable) {
        return DatasourceDeployable.class.isAssignableFrom(deployable.getClass());
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("Cannot undeploy non-datasource deployable " + deployable + ".");
        }
        if (!this.isDeployed(deployable)) {
            throw new DeployerException("Cannot undeploy datasource deployable " + deployable + " - it is not deployed.");
        }
        this.undeployDatasource((DatasourceDeployable)DatasourceDeployable.class.cast(deployable));
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public String getRarFilePathForDeployable(DatasourceDeployable deployable) {
        return this.datasourceDeployables.get(deployable);
    }

    @Override
    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    @Override
    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setServerProperties(ServerProperties props) {
        this.serverProps = props;
    }

    protected void initWorkingDirectory() {
        if (this.archiveFile == null) {
            this.archiveFile = new File(this.serverProps.getWorkDirectory() + File.separator + DEFAULT_ARCHIVE_PATH + File.separator + this.serverProps.getServerName());
            this.archiveFile.mkdirs();
        }
    }

    public String getDmRar() {
        return this.dmRar;
    }

    public void setDmRar(String dmRar) {
        this.dmRar = dmRar;
    }
}

