/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help;

import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Syntax
implements Constants {
    final String header;
    final String lead;
    final String example;
    final Pattern pattern;
    final String values;
    final Syntax[] children;
    static Syntax version = new Syntax("version", "A version range to select the version of an export definition. The default value is 0.0.0 .", "version=\"[1.2,3.0)\"", null, Verifier.VERSIONRANGE, new Syntax[0]);
    static Syntax bundle_symbolic_name = new Syntax("bundle-symbolic-name", "The bundle symbolic name of the exporting bundle.", "bundle-symbolic-name=com.acme.foo.daffy", null, Verifier.SYMBOLICNAME, new Syntax[0]);
    static Syntax bundle_version = new Syntax("bundle-version", "a version range to select the bundle version of the exporting bundle. The default value is 0.0.0.", "bundle-version=1.3", null, Verifier.VERSIONRANGE, new Syntax[0]);
    static Syntax path_version = new Syntax("version", "Specifies the range in the repository, project, or file", "version=project", "project,type", Pattern.compile("project|type|" + Verifier.VERSIONRANGE.toString()), new Syntax[0]);
    static Syntax[] syntaxes = new Syntax[]{new Syntax("Bundle-ActivationPolicy", "The Bundle-ActivationPolicy specifies how the framework should activate the bundle once started. ", "Bundle-ActivationPolicy: lazy", "lazy", Pattern.compile("lazy"), new Syntax[0]), new Syntax("Bundle-Activator", "The Bundle-Activator header specifies the name of the class used to start and stop the bundle. ", "Bundle-Activator: com.acme.foo.Activator", "${classes;implementing;org.osgi.framework.BundleActivator}", Verifier.FQNPATTERN, new Syntax[0]), new Syntax("Bundle-Category", "The Bundle-Category header holds a comma-separated list of category names", "Bundle-Category: test", "osgi,test,game,util,eclipse,netbeans,jdk,specification", null, new Syntax[0]), new Syntax("Bundle-ClassPath", "The Bundle-ClassPath header defines a comma-separated list of JAR file path names or directories (inside the bundle) containing classes and resources. The period (\u201a\u00c4\u00f4.\u201a\u00c4\u00f4) specifies the root directory of the bundle\u201a\u00c4\u00f4s JAR. The period is also the default.", "Bundle-Classpath: /lib/libnewgen.so, .", null, Verifier.PATHPATTERN, new Syntax[0]), new Syntax("Bundle-ContactAddress", "The Bundle-ContactAddress header provides the contact address of the vendor. ", "Bundle-ContactAddress: 2400 Oswego Road, Austin, TX 74563", null, null, new Syntax[0]), new Syntax("Bundle-Copyright", "The Bundle-Copyright header contains the copyright specification for this bundle. ", "Bundle-Copyright: OSGi (c) 2002", null, null, new Syntax[0]), new Syntax("Bundle-Description", "The Bundle-Description header defines a short description of this bundle.", "Bundle-Description: Ceci ce n'est pas une bundle", null, null, new Syntax[0]), new Syntax("Bundle-DocURL", "The Bundle-DocURL headers must contain a URL pointing to documentation about this bundle.", "Bundle-DocURL: http://www.aQute.biz/Code/Bnd", null, Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-Icon", "The optional Bundle-Icon header provides a list of (relative) URLs to icons representing this bundle in different sizes. ", "Bundle-Icon: /icons/bnd.png;size=64", "/icons/bundle.png", Verifier.URLPATTERN, new Syntax("size", "Icons size in pixels, e.g. 64", "64", "16,32,48,64,128", Verifier.NUMBERPATTERN, new Syntax[0])), new Syntax("Bundle-License", "The Bundle-License header provides an optional machine readable form of license information. The purpose of this header is to automate some of the license processing required by many organizations", "Bundle License: http://www.opensource.org/licenses/jabberpl.php", "http://www.apache.org/licenses/LICENSE-2.0,<<EXTERNAL>>", Pattern.compile("(" + Verifier.URLPATTERN + "|<<EXTERNAL>>)"), new Syntax("description", "Human readable description of the license", "description=\"Described the license here\"", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("link", "", "", null, Verifier.URLPATTERN, new Syntax[0])), new Syntax("Bundle-Localization", "The Bundle-Localization header contains the location in the bundle where localization files can be found. The default value is OSGI-INF/l10n/bundle. Translations are by default therefore OSGI-INF/l10n/bundle_de.properties, OSGI-INF/l10n/bundle_nl.properties, etc.", "Bundle-Localization: OSGI-INF/l10n/bundle", "OSGI-INF/l10n/bundle", Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-ManifestVersion", "This header is set by bnd automatically to 2. The Bundle-ManifestVersion header defines that the bundle follows the rules of this specification. The Bundle-ManifestVersion header determines whether the bundle follows the rules of this specification.", "# Bundle-ManifestVersion: 2", "2", Verifier.NUMBERPATTERN, new Syntax[0]), new Syntax("Bundle-Name", "This header will be derived from the  Bundle-SymbolicName if not set. The Bundle-Name header defines a readable name for this bundle. This should be a short, human-readable name that can contain spaces.", "Bundle-Name: My Bundle", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("Bundle-NativeCode", "The Bundle-NativeCode header contains a specification of native code libraries contained in this bundle. ", "Bundle-NativeCode: /lib/http.DLL; osname = QNX; osversion = 3.1", null, Verifier.PATHPATTERN, new Syntax("osname", "The name of the operating system", "osname=MacOS", Processor.join(Verifier.OSNAMES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("osversion", "Operating System Version", "osversion=3.1", null, Verifier.ANYPATTERN, new Syntax[0]), new Syntax("language", "Language ISO 639 code", "language=nl", null, Verifier.ISO639, new Syntax[0]), new Syntax("processor", "Processor name", "processor=x86", Processor.join(Verifier.PROCESSORNAMES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("selection-filter", "The value of this attribute must be a filter expression that indicates if the native code clause should be selected or not.", "selection-filter=\"(com.acme.windowing=win32)\"", null, Verifier.FILTERPATTERN, new Syntax[0])), new Syntax("Bundle-RequiredExecutionEnvironment", "The Bundle-RequiredExecutionEnvironment contains a comma-separated list of execution environments that must be present on the Service Platform.", "Bundle-RequiredExecutionEnvironment: CDC-1.0/Foundation-1.0", Processor.join(Verifier.EES, ","), Verifier.ANYPATTERN, new Syntax[0]), new Syntax("Bundle-SymbolicName", "The Bundle-SymbolicName header specifies a non-localizable name for this bundle. The bundle symbolic name together with a version must identify a  unique bundle. The bundle symbolic name should be based on the reverse  domain name convention", "Bundle-SymbolicName: com.acme.foo.daffy;singleton:=true", "${p}", Verifier.SYMBOLICNAME, new Syntax("singleton:", " Indicates that the bundle can only have  a single version resolved.  A value of true indicates that the bundle is a singleton bundle. The default value is false. The Framework must resolve at most one  bundle when multiple versions of a singleton bundle with the same symbolic name are installed. Singleton bundles do not affect the resolution of non-singleton bundles with the same symbolic name.", "false", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("fragment-attachment:", "Defines how fragments are allowed to be attached, see the fragments in Fragment Bundles on page73. The following values are valid for this directive:", "", "always|never|resolve-time", Pattern.compile("always|never|resolve-time"), new Syntax[0]), new Syntax("blueprint.wait-for-dependencies", "", "", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("blueprint.timeout", "", "", "30000,60000,300000", Verifier.NUMBERPATTERN, new Syntax[0])), new Syntax("Bundle-UpdateLocation", "The Bundle-UpdateLocation header specifies a URL where an update for this bundle should come from. If the bundle is updated, this location should be used, if present, to retrieve the updated JAR file.", "Bundle-UpdateLocation: http://www.acme.com/Firewall/bundle.jar", null, Verifier.URLPATTERN, new Syntax[0]), new Syntax("Bundle-Vendor", "The Bundle-Vendor header contains a human-readable description of the bundle vendor. ", "Bundle-Vendor: OSGi Alliance ", null, null, new Syntax[0]), new Syntax("Bundle-Version", "The Bundle-Version header specifies the version of this bundle", "Bundle-Version: 1.23.4.build200903221000", null, Verifier.VERSION, new Syntax[0]), new Syntax("DynamicImport-Package", "The DynamicImport-Package header contains a comma-separated list of package names that should be dynamically imported when needed.", "DynamicImport-Package: com.acme.plugin.*", "", Verifier.WILDCARDNAMEPATTERN, version, bundle_symbolic_name, bundle_version), new Syntax("Export-Package", "The Export-Package header contains a declaration of exported packages.", "Export-Package: org.osgi.util.tracker;version=1.3", "${packages}", null, new Syntax("-noimport:", "By default, bnd makes all exports also imports. Adding a -noimport to an exported package will make it export only", "-noimport:=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("uses:", "Calculated by bnd: It is a comma-separated list of package names that are used by the exported package", "Is calculated by bnd", null, null, new Syntax[0]), new Syntax("mandatory:", "A comma-separated list of attribute names. Note that the use of a comma in the value requires it to be enclosed in double quotes. A bundle importing the package must specify the mandatory attributes, with a value that matches, to resolve to the exported package", "mandatory=\"bar,foo\"", null, null, new Syntax[0]), new Syntax("include:", "A comma-separated list of class names that must be visible to an importer", "include:=\"Qux*\"", null, null, new Syntax[0]), new Syntax("exclude:", "A comma-separated list of class names that must not be visible to an importer", "exclude:=\"QuxImpl*,BarImpl\"", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("-import:", "Experimental", "", null, null, new Syntax[0])), new Syntax("Export-Service", "Deprecated", "Export-Service: org.osgi.service.log.LogService ", "${classes;implementing;*}", null, new Syntax[0]), new Syntax("Fragment-Host", "The Fragment-Host header defines the host bundle for this fragment.", "Fragment-Host: org.eclipse.swt; bundle-version=\"[3.0.0,4.0.0)\"", null, null, new Syntax("extension:", " Indicates this extension is a system or boot class path extension. It is only applicable when the Fragment-Host is the System Bundle", "extension:=framework", "framework,bootclasspath", Pattern.compile("framework|bootclasspath"), new Syntax[0]), bundle_version), new Syntax("Import-Package", "This header is normally calculated by bnd, however, you can decorate packages or skip packages. The Import-Package header declares the imported packages for this bundle", "Import-Package: !com.exotic.*, com.acme.foo;vendor=ACME, *", "${exported_packages}", Verifier.WILDCARDNAMEPATTERN, new Syntax("-remove-attribute:", "Remove the given attributes from matching imported packages", "-remove-attribute:=foo.*", null, Verifier.WILDCARDNAMEPATTERN, new Syntax[0]), new Syntax("resolution:", "Indicates that the packages must be resolved if the value is mandatory, which is the default. If mandatory packages cannot be resolved, then the bundle must fail to resolve. A value of optional indicates that the packages are optional", "resolution:=optional", "mandatory,optional", Pattern.compile("mandatory|optional"), new Syntax[0]), version, bundle_symbolic_name, bundle_version), new Syntax("Require-Bundle", "The Require-Bundle header specifies the required exports from another bundle.", "Require-Bundle: com.acme.chess", null, Verifier.WILDCARDNAMEPATTERN, new Syntax("visibility:", " If the value is private (Default), then all visible packages from the required bundles are not re-exported. If the value is reexport then bundles that require this bundle will transitively have access to these required bundle\u201a\u00c4\u00f4s exported packages.", "visibility:=private", "private,reexport", Pattern.compile("private|reexport"), new Syntax[0]), new Syntax("resolution:", "If the value is mandatory (default) then the required bundle must exist for this bundle to resolve. If the value is optional, the bundle will resolve even if the required bundle does not exist.", "resolution:=optional", "mandatory,optional", Pattern.compile("mandatory|optional"), new Syntax[0]), new Syntax("-split-package:", "Indicates how an imported package should be merged when it is split between different exporters. The default is merge-first with warning", "-split-package:=merge-first", "merge-first,merge-last,error,first", Pattern.compile("merge-first|merge-last|error|first"), new Syntax[0]), bundle_version), new Syntax("-bsnfromworkspace", "Calculate the default bsn from the workspace directory name + the project directory name. Default is is calculated from the project name.", "-bsnfromworkspace=true", null, null, new Syntax[0]), new Syntax("-buildpath", "Provides the class path for building the jar. The entries are references to the repository", "-buildpath=osgi;version=4.1", "${repo;bsns}", Verifier.SYMBOLICNAME, path_version), new Syntax("-bumppolicy", "Sets the version bump policy. This is a parameter to the ${version} macro.", "-bumppolicy==+0", "==+,=+0,+00", Pattern.compile("[=+-0][=+-0][=+-0]"), new Syntax[0]), new Syntax("-conduit", "Allows a bnd file to point to files which will be returned when the bnd file is build", "-conduit= jar/osgi.jar", null, null, new Syntax[0]), new Syntax("-dependson", "List of project names that this project directly depends on. These projects are always build ahead of this project", "-dependson=org.acme.cm", "${projects}", null, new Syntax[0]), new Syntax("-deployrepo", "Specifies to which repo the project should be deployed.", "-deployrepo=cnf", "${repos}", null, new Syntax[0]), new Syntax("-donotcopy", "Regular expression for names of files and directories that should not be copied when discovered", "-donotcopy=(CVS|\\.svn)", null, null, new Syntax[0]), new Syntax("-exportcontents", "Build the JAR in the normal way but use this header for the Export-Package header manifest generation, same format", "-exportcontents=!*impl*,*;version=3.0", null, null, new Syntax[0]), new Syntax("-failok", "Return with an ok status (0) even if the build generates errors", "-failok=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-include", "Include files. If an entry starts with '-', it does not have to exist. If it starts with '~', it must not overwrite any existing properties", "-include: -${java.user}/.bnd", null, null, new Syntax[0]), new Syntax("-includeresource", "Include resources from the file system. You can specify a directory, or file. All files are copied to the root, unless a destination directory is indicated", "-includeresource: lib=jar", null, null, new Syntax[0]), new Syntax("-make", "Set patterns for make plugins. These patterns are used to find a plugin that can make a resource that can not be found.", "-make: (*).jar;type=bnd;  recipe=\"bnd/$1.bnd\"", null, null, new Syntax("type", "Type name for plugin", "type=bnd", "bnd", null, new Syntax[0]), new Syntax("recipe", "Recipe for the plugin, can use back references", "recipe=\"bnd/$1.bnd\"", "bnd", null, new Syntax[0])), new Syntax("-manifest", "Directly include a manifest, do not use the calculated manifest", "-manifest = META-INF/MANIFEST.MF", null, null, new Syntax[0]), new Syntax("-noextraheaders", "Do not generate housekeeping headers", "-noextraheaders", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nouses", "Do not calculate the uses: directive on exports", "-nouses=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-nope", "Deprecated, use -nobundles. ", "-nope=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-pedantic", "Warn about things that are not really wrong but still not right", "-nope=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-plugin", "Define the plugins", "-plugin=aQute.lib.spring.SpringComponent,aQute.lib.deployer.FileRepo;location=${repo}", null, null, new Syntax[0]), new Syntax("Service-Component", "The header for Declarative Services", "Service-Component=com.acme.Foo?;activate='start'", null, null, new Syntax[0]), new Syntax("-pom", "Generate a maven pom", "-pom=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-releaserepo", "Specifies to which repo the project should be released.", "-releaserepo=cnf", "${repos}", null, new Syntax[0]), new Syntax("-removeheaders", "Remove all headers that match the regular expressions", "-removeheaders=FOO_.*,Proprietary", null, null, new Syntax[0]), new Syntax("-resourceonly", "Normally bnd warns when the JAR does not contain any classes, this option suppresses this warning", "-resourceonly=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-sources", "Include sources in the jar", "-sources=true", "true,false", Verifier.TRUEORFALSEPATTERN, new Syntax[0]), new Syntax("-sourcepath", "List of directory names that used to source sources for -sources", "-sourcepath:= src, test", null, null, new Syntax[0]), new Syntax("-sub", "Build a set of bnd files that use this bnd file as a basis. The list of bnd file can be specified with wildcards", "-sub=com.acme.*.bnd", null, null, new Syntax[0]), new Syntax("-runproperties", "Properties that are set as system properties before the framework is started", "-runproperties= foo=3, bar=4", null, null, new Syntax[0]), new Syntax("-runsystempackages", "Add additional system packages to a framework run", "-runsystempackages=com.acme.foo,javax.management", null, null, new Syntax[0]), new Syntax("-runbundles", "Add additional bundles, specified with their bsn and version like in -buildpath, that are started before the project is run", "-runbundles=osgi;version=\"[4.1,4.2)\", junit.junit, com.acme.foo;version=project", null, Verifier.SYMBOLICNAME, path_version), new Syntax("-runpath", "Additional JARs for the VM path, should include the framework", "-runpath=org.eclipse.osgi;version=3.5", null, null, path_version), new Syntax("-runvm", "Additional arguments for the VM invokation. Keys that start with a - are added as options, otherwise they are treated as -D properties for the VM", "-runvm=-Xmax=30", null, null, new Syntax[0]), new Syntax("-versionpolicy", "Provides a version policy to imports that are calculated from exports", "-versionpolicy = \"[${version;==;${@}},${version;+;${@}})\"", null, null, new Syntax[0])};
    public static final Map<String, Syntax> HELP = new HashMap<String, Syntax>();

    public Syntax(String header, String lead, String example, String values, Pattern pattern, Syntax ... children) {
        this.header = header;
        this.children = children;
        this.lead = lead;
        this.example = example;
        this.values = values;
        this.pattern = pattern;
    }

    public String getLead() {
        return this.lead;
    }

    public String getExample() {
        return this.example;
    }

    public String getValues() {
        return this.values;
    }

    public String getPattern() {
        return this.lead;
    }

    public Syntax[] getChildren() {
        return this.children;
    }

    public String getHeader() {
        return this.header;
    }

    static {
        for (Syntax s : syntaxes) {
            HELP.put(s.header, s);
        }
    }
}

