/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.msg;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;

public class IOControl {
    public static final String SOCKET_SOTIMEOUT = "fr.dyade.aaa.jndi2.socketTimeOut";
    private static int socketTimeOut = Integer.getInteger("fr.dyade.aaa.jndi2.socketTimeOut", 0);
    private Socket socket;
    private BufferedInputStream bis;
    private NetOutputStream nos;

    public IOControl(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(socketTimeOut);
        socket.setSoLinger(true, 1000);
        this.nos = new NetOutputStream(socket);
        this.bis = new BufferedInputStream(socket.getInputStream());
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(this.bis);
        return ois.readObject();
    }

    public int readInt() throws IOException {
        DataInputStream dis = new DataInputStream(this.bis);
        return dis.readInt();
    }

    public void writeObject(Object obj) throws IOException {
        this.nos.send(obj);
    }

    public void writeInt(int i) throws IOException {
        this.nos.send(i);
    }

    public void close() {
        try {
            this.socket.getInputStream().close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            this.socket.getOutputStream().close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final Socket getSocket() {
        return this.socket;
    }

    static class NetOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        private ObjectOutputStream oos = new ObjectOutputStream(this.baos);
        private OutputStream os = null;
        private static final byte[] streamHeader = new byte[]{-84, -19, 0, 5};

        NetOutputStream(Socket sock) throws IOException {
            this.baos.reset();
            this.os = sock.getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(Object msg) throws IOException {
            try {
                this.baos.write(streamHeader, 0, 4);
                this.oos.writeObject(msg);
                this.oos.flush();
                this.baos.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.oos.reset();
                this.baos.reset();
            }
        }

        void send(int i) throws IOException {
            DataOutputStream daos = new DataOutputStream(this.os);
            daos.writeInt(i);
            daos.flush();
        }
    }
}

